/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.elements;

import de.jformchecker.Criterion;
import de.jformchecker.FormChecker;
import de.jformchecker.FormCheckerElement;
import de.jformchecker.TagAttributes;
import de.jformchecker.Utils;
import de.jformchecker.criteria.MaxLength;
import de.jformchecker.validator.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractInput
implements FormCheckerElement {
    protected String name;
    protected String value;
    protected String desc;
    protected String preSetValue = "";
    private List<Criterion> criteria = new ArrayList<Criterion>();
    boolean required;
    private int tabIndex;
    String errorMessage = "";
    boolean valid = true;
    FormChecker parent;
    String helpText;

    protected String buildAllAttributes(Map<String, String> attributes) {
        StringBuilder allAttribs = new StringBuilder();
        allAttribs.append(Utils.buildAttributes(attributes));
        allAttribs.append(this.getElementId());
        allAttribs.append(this.getTabIndexTag());
        allAttribs.append(this.buildRequiredAttribute());
        if (!StringUtils.isEmpty((CharSequence)this.helpText)) {
            allAttribs.append(Utils.buildAttributes(new TagAttributes("aria-describedby", FormChecker.getHelpBlockId(this))));
        }
        return allAttribs.toString();
    }

    protected String buildRequiredAttribute() {
        if (this.required) {
            return "required ";
        }
        return "";
    }

    @Override
    public String getInputTag() {
        return this.getInputTag(new HashMap<String, String>());
    }

    @Override
    public int getLastTabIndex() {
        return this.tabIndex;
    }

    @Override
    public void setFormChecker(FormChecker fc) {
        this.parent = fc;
    }

    @Override
    public String getValueHtmlEncoded() {
        return StringEscapeUtils.escapeHtml4((String)this.value);
    }

    @Override
    public void setInvalid() {
        this.valid = false;
    }

    @Override
    public void init(HttpServletRequest request, boolean firstRun, Validator validator) {
        if (firstRun) {
            this.setValue(this.getPreSetValue());
        } else {
            this.setValue(request.getParameter(this.getName()));
            String errMsg = validator.validate(this);
            if (errMsg != null) {
                this.valid = false;
                this.setErrorMessage(errMsg);
            }
        }
    }

    @Override
    public AbstractInput setRequired() {
        this.required = true;
        return this;
    }

    @Override
    public String getLabel() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        return this.parent.getLabelForElement(this, map);
    }

    @Override
    public String getPreSetValue() {
        return this.preSetValue;
    }

    @Override
    public AbstractInput setPreSetValue(String preSetValue) {
        this.preSetValue = preSetValue;
        this.value = preSetValue;
        return this;
    }

    @Override
    public String getCompleteInput() {
        return this.getLabel() + this.getInputTag();
    }

    public String buildMaxLen() {
        List<Criterion> criteria = this.getCriteria();
        if (criteria != null) {
            for (Criterion criterion : criteria) {
                if (!(criterion instanceof MaxLength)) continue;
                return Utils.buildSingleAttribute("maxlength", "" + ((MaxLength)criterion).getMaxLength());
            }
        }
        return "";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public AbstractInput setDescription(String desc) {
        this.desc = desc;
        return this;
    }

    @Override
    public void changeDescription(String desc) {
        this.desc = desc;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public AbstractInput setCriterias(Criterion ... criteria) {
        this.criteria.addAll(Arrays.asList(criteria));
        return this;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    protected String getElementId() {
        return Utils.buildSingleAttribute("id", "form_" + this.name);
    }

    @Override
    public int getTabIndex() {
        return this.tabIndex;
    }

    public String getTabIndexTag() {
        return Utils.buildSingleAttribute("tabindex", "" + this.getTabIndex());
    }

    public String getTabIndexTagIncreaseBy(int addition) {
        return Utils.buildSingleAttribute("tabindex", "" + (this.getTabIndex() + addition));
    }

    @Override
    public AbstractInput setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
        return this;
    }

    @Override
    public List<Criterion> getCriteria() {
        return this.criteria;
    }

    @Override
    public String getHelpText() {
        return this.helpText;
    }

    public AbstractInput setHelpText(String helpText) {
        this.helpText = helpText;
        return this;
    }
}

