/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker;

import de.jformchecker.Criterion;
import de.jformchecker.FormCheckerElement;
import de.jformchecker.FormCheckerForm;
import de.jformchecker.FormValidator;
import de.jformchecker.GenericFormBuilder;
import de.jformchecker.TagAttributes;
import de.jformchecker.criteria.Criteria;
import de.jformchecker.criteria.MaxLength;
import de.jformchecker.themes.BasicFormBuilder;
import de.jformchecker.validator.DefaultValidator;
import de.jformchecker.validator.Validator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class FormChecker {
    HttpServletRequest req;
    boolean firstRun = true;
    boolean isValid = true;
    FormCheckerForm form = null;
    Validator validator = new DefaultValidator();
    boolean protectedAgainstCSRF = false;
    String completeForm;
    int defaultMaxLenElements = 1000;
    GenericFormBuilder formBuilder = new BasicFormBuilder();
    String id;
    private String formAction = "#";
    public static final String SUBMIT_KEY = "submitted";
    public static final String SUBMIT_VALUE_PREFIX = "FORMCHECKER_";

    public FormChecker(String _id, HttpServletRequest _req) {
        this.id = _id;
        this.req = _req;
    }

    public static FormChecker build(String _id, HttpServletRequest _req, FormCheckerForm form) {
        FormChecker fc = new FormChecker(_id, _req);
        fc.addForm(form);
        return fc;
    }

    public FormChecker setProtectAgainstCSRF() {
        this.protectedAgainstCSRF = true;
        return this;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isValidAndNotFirstRun() {
        return this.isValid && !this.firstRun;
    }

    public FormCheckerForm getForm() {
        return this.form;
    }

    public GenericFormBuilder getFormBuilder() {
        return this.formBuilder;
    }

    public FormChecker setFormBuilder(GenericFormBuilder formBuilder) {
        this.formBuilder = formBuilder;
        return this;
    }

    public static String getHelpBlockId(FormCheckerElement elem) {
        return "helpBlock_" + elem.getName();
    }

    public String getValue(String elementName) {
        return this.form.getElement(elementName).getValue();
    }

    public String getSubmitTag() {
        return this.formBuilder.getSubmittedTag(this.id);
    }

    public String getLabelTag(String elementName) {
        return this.formBuilder.getLabelForElement(this.form.getElement(elementName), new TagAttributes(), this.firstRun);
    }

    public String getLabelTag(String elementName, Map<String, String> map) {
        return this.formBuilder.getLabelForElement(this.form.getElement(elementName), new TagAttributes(map), this.firstRun);
    }

    public void setFormAction(String formAction) {
        this.formAction = formAction;
    }

    private void prepareElement(FormCheckerElement element) {
        element.setFormChecker(this);
        boolean maxLenAvail = false;
        for (Criterion criterion : element.getCriteria()) {
            if (!(criterion instanceof MaxLength)) continue;
            maxLenAvail = true;
        }
        if (!maxLenAvail) {
            element.getCriteria().add(Criteria.maxLength(this.defaultMaxLenElements));
        }
    }

    public void addForm(FormCheckerForm form) {
        for (FormCheckerElement element : form.getElements()) {
            this.prepareElement(element);
        }
        this.form = form;
    }

    private String getGenericForm() {
        return this.formBuilder.generateGenericForm(this.id, this.formAction, this.form.elements, this.firstRun, this, this.req);
    }

    public String getLabelForElement(FormCheckerElement e, Map<String, String> attribs) {
        return this.formBuilder.getLabelForElement(e, new TagAttributes(attribs), this.firstRun);
    }

    public FormChecker run() {
        this.sortTabIndexes();
        this.checkIfFirstRun();
        for (FormCheckerElement elem : this.form.getElements()) {
            elem.init(this.req, this.firstRun, this.validator);
            if (elem.isValid()) continue;
            this.isValid = false;
        }
        if (this.form != null) {
            for (FormValidator formValidator : this.form.getValidators()) {
                formValidator.validate(this.form);
            }
        }
        this.completeForm = this.getGenericForm();
        return this;
    }

    private void sortTabIndexes() {
        int tabIndex = 100;
        for (FormCheckerElement elem : this.form.getElements()) {
            elem.setTabIndex(tabIndex);
            tabIndex = elem.getLastTabIndex();
            ++tabIndex;
        }
    }

    private void checkIfFirstRun() {
        if ((SUBMIT_VALUE_PREFIX + this.id).equals(this.req.getParameter(SUBMIT_KEY))) {
            this.firstRun = false;
        }
    }

    public String getCompleteForm() {
        return this.completeForm;
    }
}

