/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.spring;

import de.jformchecker.FormCheckerConfig;
import de.jformchecker.GenericFormBuilder;
import de.jformchecker.spring.FCFormArgumentResolver;
import de.jformchecker.spring.JFormCheckerProperties;
import de.jformchecker.themes.BasicBootstrapFormBuilder;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableConfigurationProperties(value={JFormCheckerProperties.class})
public class JFormCheckerAutoconfiguration
extends WebMvcConfigurerAdapter
implements ApplicationContextAware {
    @Autowired
    MessageSource messageSource;
    private ApplicationContext applicationContext;
    @Autowired
    private JFormCheckerProperties jFormCheckerProperties;

    @Bean
    @ConditionalOnMissingBean
    public FormCheckerConfig getConfig() {
        return new FormCheckerConfig(key -> this.messageSource.getMessage(key, null, LocaleContextHolder.getLocale()), (GenericFormBuilder)new BasicBootstrapFormBuilder());
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolver) {
        argumentResolver.add(new FCFormArgumentResolver(this.getConfig(), this.messageSource, this.applicationContext));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

