/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.utils;

import de.jformchecker.FormCheckerElement;
import de.jformchecker.FormCheckerForm;
import de.jformchecker.elements.CheckboxInput;
import de.jformchecker.elements.DateInputCompound;
import de.jformchecker.elements.IgnoreFormElement;
import de.jformchecker.elements.Label;
import de.jformchecker.elements.LongTextInput;
import de.jformchecker.elements.NumberInput;
import de.jformchecker.elements.TextInput;
import de.jformchecker.fieldmarkers.FieldType;
import de.jformchecker.fieldmarkers.LongText;
import de.jformchecker.utils.BeanValidationFormValidator;
import de.jformchecker.utils.FormCheckerBean;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtils {
    static final Logger logger = LoggerFactory.getLogger(BeanUtils.class);

    public static FormCheckerForm fromBean(final Object o) {
        FormCheckerForm f = new FormCheckerForm(){
            private Object connectedBean;

            public void init() {
                this.connectedBean = o;
                try {
                    for (Field f : o.getClass().getDeclaredFields()) {
                        FormCheckerElement el;
                        LongText longTextMarked;
                        IgnoreFormElement ignored = f.getAnnotation(IgnoreFormElement.class);
                        if (ignored != null) continue;
                        String name = f.getName();
                        Object fieldValue = null;
                        try {
                            fieldValue = PropertyUtils.getProperty((Object)o, (String)f.getName());
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                        String description = name;
                        Label label = f.getAnnotation(Label.class);
                        if (label != null) {
                            description = label.text();
                        }
                        if ((longTextMarked = f.getAnnotation(LongText.class)) != null) {
                            el = LongTextInput.build((String)name).setDescription(description);
                            if (fieldValue != null) {
                                el.setPreSetValue(fieldValue.toString());
                            }
                        } else if (f.getAnnotation(FieldType.class) != null) {
                            FieldType fieldType = f.getAnnotation(FieldType.class);
                            Class<? extends FormCheckerElement> c = fieldType.type();
                            FormCheckerElement i = c.newInstance();
                            i.setDescription(description);
                            i.setName(name);
                            el = i;
                        } else if (fieldValue instanceof Boolean) {
                            el = CheckboxInput.build((String)name).setDescription(description);
                            if (fieldValue != null) {
                                el.setPreSetValue(fieldValue.toString());
                            }
                        } else if (fieldValue instanceof LocalDate) {
                            LocalDate dateVal = (LocalDate)fieldValue;
                            el = DateInputCompound.build((String)name).presetValue((java.util.Date)Date.valueOf(dateVal)).setDescription(description);
                        } else if (fieldValue instanceof Integer) {
                            Integer intVal = (Integer)fieldValue;
                            el = NumberInput.build((String)name).presetIntValue(intVal.intValue()).setDescription(description);
                            if (fieldValue != null) {
                                ((NumberInput)el).presetIntValue(intVal.intValue());
                            }
                        } else {
                            el = TextInput.build((String)name).setDescription(description);
                            if (fieldValue != null) {
                                el.setPreSetValue(fieldValue.toString());
                            }
                        }
                        this.add(el);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                try {
                    BeanUtils.fillBean(this, o);
                    this.addFormValidator(new BeanValidationFormValidator(o));
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        };
        if (o instanceof FormCheckerBean) {
            ((FormCheckerBean)o).preRun(f);
        }
        return f;
    }

    public static void fillBean(FormCheckerForm form, Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        List elements = form.getElements();
        for (FormCheckerElement elem : elements) {
            String key = elem.getName();
            if (PropertyUtils.isWriteable((Object)bean, (String)key)) {
                PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)bean, (String)key);
                String className = pd.getPropertyType().getName();
                if (className.equals("java.lang.String")) {
                    PropertyUtils.setSimpleProperty((Object)bean, (String)key, (Object)elem.getValue());
                    continue;
                }
                if (className.equals("java.lang.Boolean") || className.equals("boolean")) {
                    if ("true".equals(elem.getValue())) {
                        PropertyUtils.setSimpleProperty((Object)bean, (String)key, (Object)true);
                        continue;
                    }
                    PropertyUtils.setSimpleProperty((Object)bean, (String)key, (Object)false);
                    continue;
                }
                if (className.equals("java.lang.Integer") || className.equals("int")) {
                    try {
                        if (elem.getValue() == null || "".equals(elem.getValue())) continue;
                        PropertyUtils.setSimpleProperty((Object)bean, (String)key, (Object)Integer.parseInt(elem.getValue()));
                    }
                    catch (NumberFormatException e) {
                        logger.info("unable to set int property because can not parse to int", (Throwable)e);
                    }
                    continue;
                }
                if (className.equals("java.lang.Long") || className.equals("long")) {
                    try {
                        PropertyUtils.setSimpleProperty((Object)bean, (String)key, (Object)Long.parseLong(elem.getValue()));
                    }
                    catch (NumberFormatException e) {
                        logger.info("unable to set long property because can not parse to int", (Throwable)e);
                    }
                    continue;
                }
                if (!className.equals("java.time.LocalDate") || !(elem instanceof DateInputCompound)) continue;
                java.util.Date dateVal = ((DateInputCompound)elem).getDateValue();
                LocalDate dateValLocalDate = new Date(dateVal.getTime()).toLocalDate();
                PropertyUtils.setSimpleProperty((Object)bean, (String)key, (Object)dateValLocalDate);
                continue;
            }
            logger.info("unable to fill property coming from form: " + key);
        }
        if (bean instanceof FormCheckerBean) {
            ((FormCheckerBean)bean).postRun(form);
        }
    }
}

