/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.adapter;

import de.jformchecker.FormChecker;
import de.jformchecker.FormCheckerConfig;
import de.jformchecker.FormCheckerElement;
import de.jformchecker.FormCheckerForm;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.PropertyUtils;

public class FC {
    FormChecker fcInstance;

    public static FC simple(FormCheckerConfig config, HttpServletRequest request, FormCheckerForm form) {
        FC fc = new FC();
        fc.fcInstance = FormChecker.build(key -> request.getParameter(key), (FormCheckerForm)form).setConfig(config).run();
        return fc;
    }

    public static FC simple(FormCheckerConfig config, Map<String, String> paramMap, FormCheckerForm form) {
        FC fc = new FC();
        fc.fcInstance = FormChecker.build(key -> (String)paramMap.get(key), (FormCheckerForm)form).setConfig(config).run();
        return fc;
    }

    public static FC simpleFromBean(FormCheckerConfig config, Object bean, FormCheckerForm form) {
        FC fc = new FC();
        fc.fcInstance = FormChecker.build(key -> {
            try {
                return "" + PropertyUtils.getProperty((Object)bean, (String)key);
            }
            catch (Exception e) {
                return "";
            }
        }, (FormCheckerForm)form).setConfig(config).run();
        return fc;
    }

    public boolean isOk() {
        return this.fcInstance.isValidAndNotFirstRun();
    }

    public List<FormCheckerElement> getFieldList() {
        return this.fcInstance.getForm().getElements();
    }

    public Map<String, FormCheckerElement> getFields() {
        return this.fcInstance.getForm().getElementsAsMap();
    }

    public String getValueFor(String fieldName) {
        return ((FormCheckerElement)this.fcInstance.getForm().getElementsAsMap().get(fieldName)).getValue();
    }

    public static FC secure(FormCheckerConfig config, HttpServletRequest request, FormCheckerForm form) {
        FC fc = new FC();
        fc.fcInstance = FormChecker.build(key -> request.getParameter(key), (FormCheckerForm)form).setProtectAgainstCSRF(key -> request.getSession().getAttribute(key), (k, v) -> request.getSession().setAttribute(k, v)).setConfig(config).run();
        return fc;
    }

    public FormChecker getFcInstance() {
        return this.fcInstance;
    }
}

