/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.elements;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.jformchecker.FormCheckerElement;
import de.jformchecker.criteria.ValidationResult;
import de.jformchecker.elements.AbstractInput;
import de.jformchecker.request.Request;
import de.jformchecker.validator.Validator;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class RecaptchaInput
extends AbstractInput
implements FormCheckerElement {
    String siteKey = null;
    String secret = null;

    public static RecaptchaInput build(String name) {
        RecaptchaInput ci = new RecaptchaInput();
        ci.name = name;
        return ci;
    }

    public RecaptchaInput setSiteKey(String siteKey) {
        this.siteKey = siteKey;
        return this;
    }

    public RecaptchaInput setSecret(String secret) {
        this.secret = secret;
        return this;
    }

    public String getInputTag(Map<String, String> attributes) {
        return "<script src=\"https://www.google.com/recaptcha/api.js\"></script><div class=\"g-recaptcha\" data-sitekey=\"" + this.siteKey + "\"></div>";
    }

    public void init(Request request, boolean firstRun, Validator validator) {
        String userInput;
        if (!firstRun && !this.verify(userInput = request.getParameter("g-recaptcha-response"), this.secret)) {
            this.setValidationResult(ValidationResult.fail((String)"Captcha not valid", (Object[])new Object[0]));
        }
    }

    public boolean verify(String gRecaptchaResponse, String secret) {
        if (gRecaptchaResponse == null || "".equals(gRecaptchaResponse)) {
            return false;
        }
        try {
            String inputLine;
            URL obj = new URL("https://www.google.com/recaptcha/api/siteverify");
            HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            String postParams = "secret=" + secret + "&response=" + gRecaptchaResponse;
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(postParams);
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            System.err.println("Responsecode: " + responseCode);
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            System.out.println(response.toString());
            JsonObject jsonObject = new JsonParser().parse(response.toString()).getAsJsonObject();
            return jsonObject.get("success").getAsBoolean();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getType() {
        return "recaptcha";
    }
}

