/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.utils;

import de.jformchecker.FormCheckerElement;
import de.jformchecker.FormCheckerForm;
import de.jformchecker.elements.AbstractInput;
import de.jformchecker.elements.CheckboxInput;
import de.jformchecker.elements.DateInputCompound;
import de.jformchecker.elements.Label;
import de.jformchecker.elements.NumberInput;
import de.jformchecker.elements.TextInput;
import de.jformchecker.utils.BeanValidationFormValidator;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.util.Date;
import org.apache.commons.beanutils.PropertyUtils;

public class BeanValidationForm
extends FormCheckerForm {
    Object connectedBean;

    public BeanValidationForm(Object bean) {
        this.connectedBean = bean;
    }

    public void init() {
        try {
            PropertyDescriptor[] p = PropertyUtils.getPropertyDescriptors((Object)this.connectedBean);
            for (PropertyDescriptor pd : p) {
                System.err.println("typ:" + pd.getPropertyType());
                System.err.println(pd.getDisplayName());
            }
            for (Field f : this.connectedBean.getClass().getDeclaredFields()) {
                AbstractInput el;
                String name = f.getName();
                Object fieldValue = PropertyUtils.getProperty((Object)this.connectedBean, (String)f.getName());
                String description = name;
                Label label = f.getAnnotation(Label.class);
                if (label != null) {
                    description = label.text();
                }
                if (fieldValue instanceof Boolean) {
                    el = CheckboxInput.build((String)name).setDescription(description).setPreSetValue(fieldValue.toString());
                } else if (fieldValue instanceof LocalDate) {
                    LocalDate dateVal = (LocalDate)fieldValue;
                    el = DateInputCompound.build((String)name).presetValue((Date)java.sql.Date.valueOf(dateVal)).setDescription(description);
                } else if (fieldValue instanceof Integer) {
                    Integer intVal = (Integer)fieldValue;
                    el = NumberInput.build((String)name).presetIntValue(intVal.intValue()).setDescription(description);
                } else {
                    el = TextInput.build((String)name).setDescription(description).setPreSetValue(fieldValue.toString());
                }
                this.add((FormCheckerElement)el);
            }
            this.addFormValidator(new BeanValidationFormValidator(this.connectedBean));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

