/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.utils;

import de.jformchecker.FormCheckerElement;
import de.jformchecker.FormCheckerForm;
import de.jformchecker.elements.AbstractInput;
import de.jformchecker.elements.CheckboxInput;
import de.jformchecker.elements.DateInputCompound;
import de.jformchecker.elements.Label;
import de.jformchecker.elements.NumberInput;
import de.jformchecker.elements.TextInput;
import de.jformchecker.utils.BeanValidationFormValidator;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;

public class BeanUtils {
    public static FormCheckerForm fromBean(final Object o) {
        FormCheckerForm f = new FormCheckerForm(){
            private Object connectedBean;

            public void init() {
                this.connectedBean = o;
                try {
                    PropertyDescriptor[] p = PropertyUtils.getPropertyDescriptors((Object)o);
                    for (PropertyDescriptor pd : p) {
                        System.err.println("typ:" + pd.getPropertyType());
                        System.err.println(pd.getDisplayName());
                    }
                    Map elements = PropertyUtils.describe((Object)o);
                    for (Field f : o.getClass().getDeclaredFields()) {
                        AbstractInput el;
                        String name = f.getName();
                        Object fieldValue = PropertyUtils.getProperty((Object)o, (String)f.getName());
                        String description = name;
                        Label label = f.getAnnotation(Label.class);
                        if (label != null) {
                            description = label.text();
                        }
                        if (fieldValue instanceof Boolean) {
                            el = CheckboxInput.build((String)name).setDescription(description).setPreSetValue(fieldValue.toString());
                        } else if (fieldValue instanceof LocalDate) {
                            LocalDate dateVal = (LocalDate)fieldValue;
                            el = DateInputCompound.build((String)name).presetValue((java.util.Date)Date.valueOf(dateVal)).setDescription(description);
                        } else if (fieldValue instanceof Integer) {
                            Integer intVal = (Integer)fieldValue;
                            el = NumberInput.build((String)name).presetIntValue(intVal.intValue()).setDescription(description);
                        } else {
                            el = TextInput.build((String)name).setDescription(description).setPreSetValue(fieldValue.toString());
                        }
                        this.add((FormCheckerElement)el);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                try {
                    BeanUtils.fillBean(this.getElements(), o);
                    this.addFormValidator(new BeanValidationFormValidator(o));
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        };
        return f;
    }

    public static void fillBean(List<FormCheckerElement> elements, Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (FormCheckerElement elem : elements) {
            String key = elem.getName();
            if (!PropertyUtils.isWriteable((Object)bean, (String)key)) continue;
            Object propertyVal = PropertyUtils.getSimpleProperty((Object)bean, (String)key);
            if (propertyVal instanceof String) {
                PropertyUtils.setSimpleProperty((Object)bean, (String)key, (Object)elem.getValue());
                continue;
            }
            if (propertyVal instanceof Boolean) {
                if ("true".equals(elem.getValue())) {
                    PropertyUtils.setSimpleProperty((Object)bean, (String)key, (Object)true);
                    continue;
                }
                PropertyUtils.setSimpleProperty((Object)bean, (String)key, (Object)false);
                continue;
            }
            if (propertyVal instanceof Integer) {
                PropertyUtils.setSimpleProperty((Object)bean, (String)key, (Object)Integer.parseInt(elem.getValue()));
                continue;
            }
            if (!(propertyVal instanceof LocalDate) || !(elem instanceof DateInputCompound)) continue;
            java.util.Date dateVal = ((DateInputCompound)elem).getDateValue();
            LocalDate dateValLocalDate = new Date(dateVal.getTime()).toLocalDate();
            PropertyUtils.setSimpleProperty((Object)bean, (String)key, (Object)dateValLocalDate);
        }
    }
}

