/*
 * Decompiled with CFR 0.152.
 */
package de.cwkr.validation.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Lists {
    private Lists() {
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... elements) {
        ArrayList<T> list = new ArrayList<T>(elements.length);
        for (T element : elements) {
            list.add(element);
        }
        return list;
    }

    public static <T> List<T> listOf(Collection<? extends T> collection) {
        return new ArrayList<T>(collection);
    }

    @SafeVarargs
    public static <T> List<T> unmodifiableListOf(T ... elements) {
        return Collections.unmodifiableList(Lists.listOf(elements));
    }

    public static <T> List<T> unmodifiableListOf(Collection<? extends T> collection) {
        return Collections.unmodifiableList(Lists.listOf(collection));
    }
}

