/*
 * Decompiled with CFR 0.152.
 */
package de.cwkr.util;

import java.util.Iterator;
import java.util.Objects;

public final class UnmodifiableIterator<E>
implements Iterator<E> {
    private final Iterator<? extends E> iterator;

    private UnmodifiableIterator(Iterator<? extends E> iterator) {
        this.iterator = iterator;
    }

    public static <E> Iterator<E> unmodifiableIterator(Iterator<? extends E> iterator) {
        Objects.requireNonNull(iterator, "iterator must not be null");
        return new UnmodifiableIterator<E>(iterator);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported");
    }
}

