/*
 * Decompiled with CFR 0.152.
 */
package de.cwkr.util;

import java.security.SecureRandom;
import java.util.Random;
import org.apache.commons.lang3.Validate;

public final class Ulids {
    private static final int MASK = 31;
    private static final int MASK_BITS = 5;
    private static final long MAX_TIMESTAMP = 0xFFFFFFFFFFFFL;
    private static final String CROCKFORD_BASE32_CHARS = "0123456789ABCDEFGHJKMNPQRSTVWXYZ";
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    private Ulids() {
    }

    public static String ulid() {
        return Ulids.ulidOf(System.currentTimeMillis(), SECURE_RANDOM);
    }

    public static String ulidOf(long timestamp, Random random) {
        Validate.inclusiveBetween((long)0L, (long)0xFFFFFFFFFFFFL, (long)timestamp);
        Validate.notNull((Object)random, (String)"random must not be null", (Object[])new Object[0]);
        char[] buffer = new char[26];
        Ulids.writeBase32(buffer, timestamp, 10, 0);
        Ulids.writeBase32(buffer, random.nextLong(), 8, 10);
        Ulids.writeBase32(buffer, random.nextLong(), 8, 18);
        return new String(buffer);
    }

    private static void writeBase32(char[] buffer, long value, int count, int offset) {
        for (int i = 0; i < count; ++i) {
            int index = (int)(value >>> (count - i - 1) * 5 & 0x1FL);
            buffer[offset + i] = CROCKFORD_BASE32_CHARS.charAt(index);
        }
    }
}

