/*
 * Decompiled with CFR 0.152.
 */
package de.cwkr.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public final class Sets {
    private Sets() {
    }

    public static <T> Set<T> emptyOrderedSet() {
        return new LinkedHashSet();
    }

    public static <T> Set<T> orderedSetOf(T element) {
        Validate.notNull(element);
        LinkedHashSet<T> set = new LinkedHashSet<T>(1);
        set.add(element);
        return set;
    }

    @SafeVarargs
    public static <T> Set<T> orderedSetOf(T ... elements) {
        Validate.noNullElements((Object[])elements);
        LinkedHashSet<T> set = new LinkedHashSet<T>(elements.length);
        set.addAll(Arrays.asList(elements));
        return set;
    }

    public static <T> Set<T> orderedSetOf(Collection<? extends T> collection) {
        Validate.noNullElements(collection);
        return new LinkedHashSet<T>(collection);
    }

    public static <T> Set<T> unmodifiableSetOf(T element) {
        Validate.notNull(element);
        return Collections.singleton(element);
    }

    @SafeVarargs
    public static <T> Set<T> unmodifiableSetOf(T ... elements) {
        return Collections.unmodifiableSet(Sets.orderedSetOf(elements));
    }

    public static <T> Set<T> unmodifiableSetOf(Collection<? extends T> collection) {
        return Collections.unmodifiableSet(Sets.orderedSetOf(collection));
    }
}

