/*
 * Decompiled with CFR 0.152.
 */
package de.cwkr.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;

public final class Lists {
    private Lists() {
    }

    public static <T> List<T> emptyList() {
        return new ArrayList();
    }

    public static <T> List<T> listOf(T element) {
        Validate.notNull(element);
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(element);
        return list;
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... elements) {
        Validate.noNullElements((Object[])elements);
        ArrayList<T> list = new ArrayList<T>(elements.length);
        list.addAll(Arrays.asList(elements));
        return list;
    }

    public static <T> List<T> listOf(Collection<? extends T> collection) {
        Validate.noNullElements(collection);
        return new ArrayList<T>(collection);
    }

    public static <T> List<T> unmodifiableListOf(T element) {
        Validate.notNull(element);
        return Collections.singletonList(element);
    }

    @SafeVarargs
    public static <T> List<T> unmodifiableListOf(T ... elements) {
        return Collections.unmodifiableList(Lists.listOf(elements));
    }

    public static <T> List<T> unmodifiableListOf(Collection<? extends T> collection) {
        return Collections.unmodifiableList(Lists.listOf(collection));
    }
}

