/*
 * Decompiled with CFR 0.152.
 */
package de.cwkr.util;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public final class Maps {
    private Maps() {
    }

    public static <K, V> Map<K, V> emptyOrderedMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> orderedMapOf(K key, V value) {
        Validate.notNull(key);
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(1);
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> orderedMapOf(K k1, V v1, K k2, V v2) {
        Validate.notNull(k1);
        Validate.notNull(k2);
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> Map<K, V> orderedMapOf(K k1, V v1, K k2, V v2, K k3, V v3) {
        Validate.notNull(k1);
        Validate.notNull(k2);
        Validate.notNull(k3);
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    @SafeVarargs
    public static <T> Map<T, T> orderedMapOf(T ... kv) {
        Validate.noNullElements((Object[])kv);
        Validate.isTrue((kv.length % 2 == 0 ? 1 : 0) != 0, (String)"Number of key-value elements must be symmetric", (Object[])new Object[0]);
        LinkedHashMap<T, T> map = new LinkedHashMap<T, T>(kv.length / 2);
        for (int i = 0; i < kv.length; i += 2) {
            map.put(kv[i], kv[i + 1]);
        }
        return map;
    }

    public static <K, V> Map<K, V> orderedMapOfEntries(Map.Entry<K, V> entry) {
        Validate.notNull(entry);
        Validate.notNull(entry.getKey());
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(1);
        map.put(entry.getKey(), entry.getValue());
        return map;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> orderedMapOfEntries(Map.Entry<K, V> ... entries) {
        Validate.noNullElements((Object[])entries);
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(entries.length);
        for (Map.Entry<K, V> entry : entries) {
            Validate.notNull(entry.getKey());
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static <K, V> Map.Entry<K, V> entryOf(K key, V value) {
        Validate.notNull(key);
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    public static <K, V> Map.Entry<K, V> unmodifiableEntryOf(K key, V value) {
        Validate.notNull(key);
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    public static <K, V> Map<K, V> unmodifiableMapOf(K key, V value) {
        Validate.notNull(key);
        return Collections.singletonMap(key, value);
    }

    public static <K, V> Map<K, V> unmodifiableMapOf(K k1, V v1, K k2, V v2) {
        return Collections.unmodifiableMap(Maps.orderedMapOf(k1, v1, k2, v2));
    }

    public static <K, V> Map<K, V> unmodifiableMapOf(K k1, V v1, K k2, V v2, K k3, V v3) {
        return Collections.unmodifiableMap(Maps.orderedMapOf(k1, v1, k2, v2, k3, v3));
    }

    @SafeVarargs
    public static <T> Map<T, T> unmodifiableMapOf(T ... kv) {
        return Collections.unmodifiableMap(Maps.orderedMapOf(kv));
    }

    public static <K, V> Map<K, V> unmodifiableMapOfEntries(Map.Entry<K, V> entry) {
        Validate.notNull(entry.getKey());
        return Collections.singletonMap(entry.getKey(), entry.getValue());
    }

    @SafeVarargs
    public static <K, V> Map<K, V> unmodifiableMapOfEntries(Map.Entry<K, V> ... entries) {
        return Collections.unmodifiableMap(Maps.orderedMapOfEntries(entries));
    }
}

