/*
 * Decompiled with CFR 0.152.
 */
package de.cwkr.util;

import de.cwkr.util.ExceptionProducer;
import de.cwkr.util.UnmodifiableIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public final class Errors
implements Iterable<String> {
    private static final Logger logger = LoggerFactory.getLogger(Errors.class);
    private final List<String> errors = new CopyOnWriteArrayList<String>();

    public Errors() {
    }

    public Errors(Iterable<String> errors) {
        this.addErrors(errors);
    }

    public List<String> getErrors() {
        logger.trace("getErrors()");
        return Collections.unmodifiableList(this.errors);
    }

    public void reset() {
        logger.trace("reset()");
        this.errors.clear();
    }

    public void addError(String error) {
        logger.trace("addError(error = {})", (Object)error);
        this.errors.add(error);
    }

    public void addErrors(Iterable<String> errors) {
        logger.trace("addErrors(errors = {})", errors);
        Objects.requireNonNull(errors, "errors must not be null");
        errors.forEach(this::addError);
    }

    public void addErrors(String ... errors) {
        if (logger.isTraceEnabled()) {
            logger.trace("addErrors(errors = {})", (Object)Arrays.toString(errors));
        }
        Objects.requireNonNull(errors, "errors must not be null");
        Arrays.stream(errors).forEach(this::addError);
    }

    public int countErrors() {
        logger.trace("countErrors()");
        return this.errors.size();
    }

    public boolean hasErrors() {
        logger.trace("hasErrors()");
        return !this.errors.isEmpty();
    }

    public void logErrors(Logger logger) {
        Errors.logger.trace("logErrors(logger = {})", (Object)logger);
        Objects.requireNonNull(logger, "logger must not be null");
        this.errors.forEach(arg_0 -> ((Logger)logger).error(arg_0));
    }

    public void logErrors() {
        logger.trace("logErrors()");
        this.logErrors(logger);
    }

    public void throwErrors(ExceptionProducer<? extends RuntimeException> exceptionProducer, String msg, Object ... params) {
        if (logger.isTraceEnabled()) {
            logger.trace("throwErrors(exceptionProducer = {}, msg = {}, params = {})", new Object[]{exceptionProducer, msg, Arrays.toString(params)});
        }
        if (this.hasErrors()) {
            throw exceptionProducer.produce(MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage(), this.getErrors());
        }
    }

    @Override
    public Iterator<String> iterator() {
        logger.trace("iterator()");
        return UnmodifiableIterator.unmodifiableIterator(this.errors.iterator());
    }

    public String toString() {
        logger.trace("toString()");
        return new ToStringBuilder((Object)this).append("errors", this.errors).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Errors that = (Errors)o;
        return new EqualsBuilder().append(this.errors, that.errors).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.errors).toHashCode();
    }

    public void isNull(Object obj, String msg, Object ... params) {
        if (logger.isTraceEnabled()) {
            logger.trace("isNull(obj = {}, msg = {}, params = {})", new Object[]{obj, msg, Arrays.toString(params)});
        }
        if (!Objects.isNull(obj)) {
            this.errors.add(MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage());
        }
    }

    public void isNotNull(Object obj, String msg, Object ... params) {
        if (logger.isTraceEnabled()) {
            logger.trace("isNotNull(obj = {}, msg = {}, params = {})", new Object[]{obj, msg, Arrays.toString(params)});
        }
        if (Objects.isNull(obj)) {
            this.errors.add(MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage());
        }
    }

    public void isEmpty(CharSequence obj, String msg, Object ... params) {
        if (logger.isTraceEnabled()) {
            logger.trace("isEmpty(obj = {}, msg = {}, params = {})", new Object[]{obj, msg, Arrays.toString(params)});
        }
        if (StringUtils.isNotEmpty((CharSequence)obj)) {
            this.errors.add(MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage());
        }
    }

    public void isNotEmpty(CharSequence obj, String msg, Object ... params) {
        if (logger.isTraceEnabled()) {
            logger.trace("isNotEmpty(obj = {}, msg = {}, params = {})", new Object[]{obj, msg, Arrays.toString(params)});
        }
        if (StringUtils.isEmpty((CharSequence)obj)) {
            this.errors.add(MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage());
        }
    }

    public void isEmpty(Collection<?> obj, String msg, Object ... params) {
        if (logger.isTraceEnabled()) {
            logger.trace("isEmpty(obj = {}, msg = {}, params = {})", new Object[]{obj, msg, Arrays.toString(params)});
        }
        if (!obj.isEmpty()) {
            this.errors.add(MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage());
        }
    }

    public void isNotEmpty(Collection<?> obj, String msg, Object ... params) {
        if (logger.isTraceEnabled()) {
            logger.trace("isNotEmpty(obj = {}, msg = {}, params = {})", new Object[]{obj, msg, Arrays.toString(params)});
        }
        if (obj.isEmpty()) {
            this.errors.add(MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage());
        }
    }

    public void isBlank(CharSequence obj, String msg, Object ... params) {
        if (logger.isTraceEnabled()) {
            logger.trace("isBlank(obj = {}, msg = {}, params = {})", new Object[]{obj, msg, Arrays.toString(params)});
        }
        if (StringUtils.isNotBlank((CharSequence)obj)) {
            this.errors.add(MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage());
        }
    }

    public void isNotBlank(CharSequence obj, String msg, Object ... params) {
        if (logger.isTraceEnabled()) {
            logger.trace("isNotBlank(obj = {}, msg = {}, params = {})", new Object[]{obj, msg, Arrays.toString(params)});
        }
        if (StringUtils.isBlank((CharSequence)obj)) {
            this.errors.add(MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage());
        }
    }

    public void isContainingDuplicates(Collection<?> obj, String msg, Object ... params) {
        if (logger.isTraceEnabled()) {
            logger.trace("isContainingDuplicates(obj = {}, msg = {}, params = {})", new Object[]{obj, msg, Arrays.toString(params)});
        }
        if (obj.stream().noneMatch(e -> Collections.frequency(obj, e) > 1)) {
            this.errors.add(MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage());
        }
    }

    public void isNotContainingDuplicates(Collection<?> obj, String msg, Object ... params) {
        if (logger.isTraceEnabled()) {
            logger.trace("isNotContainingDuplicates(obj = {}, msg = {}, params = {})", new Object[]{obj, msg, Arrays.toString(params)});
        }
        if (obj.stream().anyMatch(e -> Collections.frequency(obj, e) > 1)) {
            this.errors.add(MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage());
        }
    }

    public void isBetween(int num, int min, int max, String msg, Object ... params) {
        if (logger.isTraceEnabled()) {
            logger.trace("isBetween(num = {}, min = {}, max = {}, msg = {}, params = {})", new Object[]{num, min, max, msg, Arrays.toString(params)});
        }
        if (num < min || num > max) {
            this.errors.add(MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage());
        }
    }

    public void isTrue(boolean obj, String msg, Object ... params) {
        if (logger.isTraceEnabled()) {
            logger.trace("isTrue(obj = {}, msg = {}, params = {})", new Object[]{obj, msg, Arrays.toString(params)});
        }
        if (!obj) {
            this.errors.add(MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage());
        }
    }

    public void isFalse(boolean obj, String msg, Object ... params) {
        if (logger.isTraceEnabled()) {
            logger.trace("isFalse(obj = {}, msg = {}, params = {})", new Object[]{obj, msg, Arrays.toString(params)});
        }
        if (obj) {
            this.errors.add(MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage());
        }
    }

    public void isEqual(Object obj, Object other, String msg, Object ... params) {
        if (logger.isTraceEnabled()) {
            logger.trace("isEqual(obj = {}, other = {}, msg = {}, params = {})", new Object[]{obj, other, msg, Arrays.toString(params)});
        }
        if (!Objects.equals(obj, other)) {
            this.errors.add(MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage());
        }
    }

    public void isNotEqual(Object obj, Object other, String msg, Object ... params) {
        if (logger.isTraceEnabled()) {
            logger.trace("isNotEqual(obj = {}, other = {}, msg = {}, params = {})", new Object[]{obj, other, msg, Arrays.toString(params)});
        }
        if (Objects.equals(obj, other)) {
            this.errors.add(MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage());
        }
    }
}

