/*
 * Decompiled with CFR 0.152.
 */
package de.customed.common;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class BirthDate
implements Serializable {
    private String date;

    public BirthDate(String date) {
        this.date = date;
    }

    public BirthDate() {
    }

    public BirthDate(String value, String dateFormat) {
        SimpleDateFormat myFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat otherFormat = new SimpleDateFormat(dateFormat);
        try {
            this.date = myFormat.format(otherFormat.parse(value));
        }
        catch (ParseException e) {
            System.err.println("Date could not be parsed");
            System.err.println(e);
        }
    }

    public BirthDate(Date time) {
        if (time == null) {
            time = new Date();
        }
        SimpleDateFormat myFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.date = myFormat.format(time);
    }

    public boolean isEmpty() {
        return this.date == null || this.date.isEmpty();
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public int getAge() {
        return this.getAgeAtTimePoint(new Date());
    }

    public int getAgeAtTimePoint(Date timepoint) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date javaDate = format.parse(this.date);
            Calendar calendarBirthDate = Calendar.getInstance();
            Calendar calendarTimePoint = Calendar.getInstance();
            calendarBirthDate.setTime(javaDate);
            calendarTimePoint.setTime(timepoint);
            int diff = calendarTimePoint.get(1) - calendarBirthDate.get(1);
            if (calendarBirthDate.get(2) > calendarTimePoint.get(2) || calendarBirthDate.get(2) == calendarTimePoint.get(2) && calendarBirthDate.get(5) > calendarTimePoint.get(5)) {
                --diff;
            }
            return diff;
        }
        catch (ParseException e) {
            System.err.println("Date could not be parsed");
            System.err.println(e);
            return 0;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof BirthDate) {
            BirthDate birthDate = (BirthDate)obj;
            if (birthDate.date == null) {
                return this.date == null;
            }
            return ((BirthDate)obj).date.equals(this.date);
        }
        return false;
    }

    public Date toDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return format.parse(this.date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getAgeString() {
        return this.getAge() + "y";
    }

    public String toFormat(String format) {
        SimpleDateFormat myFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat otherFormat = new SimpleDateFormat(format);
        try {
            return otherFormat.format(myFormat.parse(this.date));
        }
        catch (ParseException e) {
            System.err.println("Date could not be parsed");
            System.err.println(e);
            return "";
        }
    }

    public String toString() {
        return this.date;
    }
}

