/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.property;

import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.test.valueobjects.property.util.AssertionStrategy;
import de.cuioss.test.valueobjects.property.util.CollectionAsserts;
import lombok.Generated;
import lombok.NonNull;
import org.junit.jupiter.api.Assertions;

public class PropertySupport {
    private static final int ENTROPY_GUARD = 50;
    private static final String TARGET_MUST_NOT_BE_NULL = "target must not be null";
    @NonNull
    private final PropertyMetadata propertyMetadata;
    private Object generatedValue;

    public boolean isReadable() {
        return this.propertyMetadata.getPropertyReadWrite().isReadable();
    }

    public boolean isDefaultValue() {
        return this.propertyMetadata.isDefaultValue();
    }

    public boolean isRequired() {
        return this.propertyMetadata.isRequired();
    }

    public String getName() {
        return this.propertyMetadata.getName();
    }

    public boolean isPrimitive() {
        return this.propertyMetadata.resolveActualClass().isPrimitive();
    }

    public Object generateTestValue() {
        this.setGeneratedValue(this.propertyMetadata.next());
        return this.getGeneratedValue();
    }

    public void reset() {
        this.setGeneratedValue(null);
    }

    public void apply(Object target) {
        this.writeProperty(target, this.generatedValue);
    }

    public void assertValueSet(Object target) {
        this.assertValueSet(target, this.generatedValue);
    }

    public void assertValueSet(Object target, Object expected) {
        Object actual = this.readProperty(target);
        if (AssertionStrategy.COLLECTION_IGNORE_ORDER.equals((Object)this.propertyMetadata.getAssertionStrategy())) {
            CollectionAsserts.assertListsAreEqualIgnoringOrder(this.propertyMetadata.getName(), expected, actual);
        } else {
            Assertions.assertEquals((Object)expected, (Object)actual, (String)("Invalid content found for property " + this.propertyMetadata.getName() + ", expected=" + expected + ", actual=" + actual));
        }
    }

    public Object readProperty(Object target) {
        Assertions.assertNotNull((Object)target, (String)TARGET_MUST_NOT_BE_NULL);
        return this.propertyMetadata.getPropertyAccessStrategy().readProperty(target, this.propertyMetadata);
    }

    public Object writeProperty(Object target, Object propertyValue) {
        Assertions.assertNotNull((Object)target, (String)TARGET_MUST_NOT_BE_NULL);
        return this.propertyMetadata.getPropertyAccessStrategy().writeProperty(target, this.propertyMetadata, propertyValue);
    }

    public void assertDefaultValue(Object target) {
        Assertions.assertNotNull((Object)target, (String)TARGET_MUST_NOT_BE_NULL);
        Assertions.assertTrue((boolean)this.propertyMetadata.isDefaultValue(), (String)("There is no default value set: Invalid configuration for property " + this.propertyMetadata.getName()));
        Assertions.assertNotNull((Object)this.readProperty(target), (String)("No defaultValue found for property " + this.propertyMetadata.getName()));
    }

    public PropertySupport createCopy(boolean withGeneratedValue) {
        PropertySupport support = new PropertySupport(this.propertyMetadata);
        if (withGeneratedValue) {
            support.setGeneratedValue(this.generatedValue);
        }
        return support;
    }

    public PropertySupport createCopyWithNonEqualValue() {
        Object otherValue;
        PropertySupport support = new PropertySupport(this.propertyMetadata);
        if (null == this.getGeneratedValue()) {
            support.generateTestValue();
            return support;
        }
        int times = 0;
        Object initialTestValue = this.getGeneratedValue();
        while (initialTestValue.equals(otherValue = support.generateTestValue())) {
            if (50 == ++times) {
                throw new AssertionError((Object)("Unable to create non equal test-value for " + this.propertyMetadata));
            }
        }
        return support;
    }

    @Generated
    public PropertySupport(@NonNull PropertyMetadata propertyMetadata) {
        if (propertyMetadata == null) {
            throw new NullPointerException("propertyMetadata is marked non-null but is null");
        }
        this.propertyMetadata = propertyMetadata;
    }

    @Generated
    public String toString() {
        return "PropertySupport(propertyMetadata=" + this.getPropertyMetadata() + ", generatedValue=" + this.getGeneratedValue() + ")";
    }

    @NonNull
    @Generated
    public PropertyMetadata getPropertyMetadata() {
        return this.propertyMetadata;
    }

    @Generated
    public Object getGeneratedValue() {
        return this.generatedValue;
    }

    @Generated
    public void setGeneratedValue(Object generatedValue) {
        this.generatedValue = generatedValue;
    }
}

