/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.generator.dynamic.impl;

import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.generator.impl.CollectionGenerator;
import de.cuioss.test.generator.impl.PrimitiveArrayGenerators;
import de.cuioss.test.valueobjects.generator.dynamic.GeneratorResolver;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class ArraysGenerator<T, C>
implements TypedGenerator<T> {
    @NonNull
    private final Class<T> type;
    @NonNull
    private final Class<C> componentType;
    @NonNull
    private final CollectionGenerator<?> collectionGenerator;

    public T next() {
        List collection = this.collectionGenerator.list();
        if (!this.componentType.isPrimitive()) {
            Object[] array = (Object[])Array.newInstance(this.componentType, collection.size());
            return (T)collection.toArray(array);
        }
        return (T)PrimitiveArrayGenerators.resolveForType(this.componentType).next();
    }

    public static final <T> Optional<TypedGenerator<T>> getGeneratorForType(Class<T> type) {
        if (null == type || !type.isArray()) {
            return Optional.empty();
        }
        Class<?> componentType = type.getComponentType();
        TypedGenerator<?> wrappedGenerator = GeneratorResolver.resolveGenerator(componentType);
        return Optional.of(new ArraysGenerator(type, componentType, new CollectionGenerator(wrappedGenerator)));
    }

    @Generated
    public ArraysGenerator(@NonNull Class<T> type, @NonNull Class<C> componentType, @NonNull CollectionGenerator<?> collectionGenerator) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (componentType == null) {
            throw new NullPointerException("componentType is marked non-null but is null");
        }
        if (collectionGenerator == null) {
            throw new NullPointerException("collectionGenerator is marked non-null but is null");
        }
        this.type = type;
        this.componentType = componentType;
        this.collectionGenerator = collectionGenerator;
    }

    @NonNull
    @Generated
    public Class<T> getType() {
        return this.type;
    }
}

