/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.contract.support;

import de.cuioss.test.valueobjects.api.VerifyMapperConfiguration;
import de.cuioss.test.valueobjects.contract.support.MappingTuple;
import de.cuioss.test.valueobjects.property.PropertySupport;
import de.cuioss.tools.collect.CollectionLiterals;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum MappingAssertStrategy {
    EQUALS{

        @Override
        public void assertMapping(PropertySupport sourceProperty, Object sourceObject, PropertySupport targetProperty, Object targetObject) {
            targetProperty.assertValueSet(targetObject, sourceProperty.readProperty(sourceObject));
        }

        @Override
        public List<MappingTuple> readConfiguration(VerifyMapperConfiguration config) {
            return CollectionLiterals.mutableList((Object[])config.equals()).stream().map(mapping -> new MappingTuple((String)mapping, this)).toList();
        }
    }
    ,
    NOT_NULL{

        @Override
        public void assertMapping(PropertySupport sourceProperty, Object sourceObject, PropertySupport targetProperty, Object targetObject) {
            Object readProperty = targetProperty.readProperty(targetObject);
            Assertions.assertNotNull((Object)readProperty, (String)("The given object must not be null " + targetProperty.getPropertyMetadata()));
            if (readProperty instanceof Collection) {
                Collection collection = (Collection)readProperty;
                Assertions.assertFalse((boolean)collection.isEmpty(), (String)("The given object is not null but an empty collection" + targetProperty.getPropertyMetadata()));
            }
        }

        @Override
        public List<MappingTuple> readConfiguration(VerifyMapperConfiguration config) {
            return CollectionLiterals.mutableList((Object[])config.notNullNorEmpty()).stream().map(mapping -> new MappingTuple((String)mapping, this)).toList();
        }
    }
    ,
    NULL_OR_DEFAULT{

        @Override
        public void assertMapping(PropertySupport sourceProperty, Object sourceObject, PropertySupport targetProperty, Object targetObject) {
            if (targetProperty.isDefaultValue()) {
                return;
            }
            Object read = targetProperty.readProperty(targetObject);
            if (read instanceof Collection) {
                Collection collection = (Collection)read;
                Assertions.assertTrue((boolean)collection.isEmpty(), (String)("The given object is not null nor an empty collection" + targetProperty.getPropertyMetadata()));
            } else {
                Assertions.assertNull((Object)read, (String)("The given object must be null " + targetProperty.getPropertyMetadata()));
            }
        }

        @Override
        public List<MappingTuple> readConfiguration(VerifyMapperConfiguration config) {
            return Collections.emptyList();
        }
    };


    public abstract void assertMapping(PropertySupport var1, Object var2, PropertySupport var3, Object var4);

    public abstract List<MappingTuple> readConfiguration(VerifyMapperConfiguration var1);
}

