/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.contract;

import de.cuioss.test.valueobjects.api.TestContract;
import de.cuioss.test.valueobjects.api.contracts.VerifyCopyConstructor;
import de.cuioss.test.valueobjects.generator.impl.DummyGenerator;
import de.cuioss.test.valueobjects.objects.ParameterizedInstantiator;
import de.cuioss.test.valueobjects.objects.RuntimeProperties;
import de.cuioss.test.valueobjects.objects.impl.ConstructorBasedInstantiator;
import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.test.valueobjects.property.PropertySupport;
import de.cuioss.test.valueobjects.property.impl.PropertyMetadataImpl;
import de.cuioss.test.valueobjects.util.DeepCopyTestHelper;
import de.cuioss.test.valueobjects.util.PropertyHelper;
import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.reflect.MoreReflection;
import de.cuioss.tools.string.Joiner;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.junit.jupiter.api.Assertions;

public class CopyConstructorContractImpl<T>
implements TestContract<T> {
    private static final CuiLogger log = new CuiLogger(CopyConstructorContractImpl.class);
    private static final String PROPERTY_NAME_COPY_FROM = "copyFrom";
    private final ParameterizedInstantiator<T> copyInstantiator;
    @NonNull
    private final ParameterizedInstantiator<T> instantiator;
    private final Set<String> consideredAttributes;
    private final boolean useObjectEquals;
    private final boolean verifyDeepCopy;
    private final Collection<String> verifyDeepCopyIgnore;

    @Override
    public void assertContract() {
        StringBuilder builder = new StringBuilder("Verifying ");
        builder.append(this.getClass().getName()).append("\nWith instantiator: ").append(this.copyInstantiator.toString()).append("\nWith sourceInstantiator: ").append(this.instantiator.toString());
        log.info(builder.toString());
        Set<String> sourceAttributeNames = RuntimeProperties.extractNames(this.instantiator.getRuntimeProperties().getAllProperties());
        HashSet<String> compareAttributes = new HashSet<String>(this.consideredAttributes);
        if (!sourceAttributeNames.containsAll(this.consideredAttributes)) {
            builder = new StringBuilder("Not all attributes can be checked at field level:");
            builder.append("\nSource attributes are: ").append(sourceAttributeNames);
            builder.append("\nCompare attributes are: ").append(this.consideredAttributes);
            log.warn(builder.toString());
            compareAttributes.retainAll(sourceAttributeNames);
        }
        log.info("Attributes being compared at field level are: " + Joiner.on((String)", ").join(compareAttributes));
        this.assertCopyConstructor(compareAttributes);
        this.assertDeepCopy();
    }

    private void assertDeepCopy() {
        if (!this.verifyDeepCopy) {
            log.debug("Not checking deep-copy, disabled by configuration");
            return;
        }
        log.info("Verifying deep-copy, ignoring properties: {}" + this.verifyDeepCopyIgnore);
        List<PropertySupport> all = this.instantiator.getRuntimeProperties().getAllAsPropertySupport(true);
        PropertySupport copyAttribute = this.copyInstantiator.getRuntimeProperties().getAllAsPropertySupport(false).iterator().next();
        copyAttribute.setGeneratedValue(this.instantiator.newInstance(all, false));
        Object original = copyAttribute.getGeneratedValue();
        T copy = this.copyInstantiator.newInstance(CollectionLiterals.immutableList((Object)copyAttribute), false);
        DeepCopyTestHelper.verifyDeepCopy(original, copy, this.verifyDeepCopyIgnore);
    }

    private void assertCopyConstructor(Set<String> compareAttributes) {
        List<PropertySupport> all = this.instantiator.getRuntimeProperties().getAllAsPropertySupport(true);
        PropertySupport copyAttribute = this.copyInstantiator.getRuntimeProperties().getAllAsPropertySupport(false).iterator().next();
        copyAttribute.setGeneratedValue(this.instantiator.newInstance(all, false));
        T copy = this.copyInstantiator.newInstance(CollectionLiterals.immutableList((Object)copyAttribute), false);
        List<PropertySupport> fieldLevelCheck = all.stream().filter(p -> compareAttributes.contains(p.getName())).toList();
        for (PropertySupport field : fieldLevelCheck) {
            if (!field.isReadable()) continue;
            field.assertValueSet(copy);
        }
        if (this.useObjectEquals) {
            Assertions.assertEquals((Object)copyAttribute.getGeneratedValue(), copy);
        }
    }

    public static final <T> Optional<CopyConstructorContractImpl<T>> createTestContract(Class<T> beanType, Class<?> annotated, List<PropertyMetadata> initialPropertyMetadata, List<TestContract<T>> existingContracts) {
        Objects.requireNonNull(annotated, "annotated must not be null");
        Optional configOption = MoreReflection.extractAnnotation(annotated, VerifyCopyConstructor.class);
        if (configOption.isEmpty()) {
            return Optional.empty();
        }
        Objects.requireNonNull(beanType, "beantype must not be null");
        Objects.requireNonNull(initialPropertyMetadata, "initialPropertyMetadata must not be null");
        Objects.requireNonNull(existingContracts, "existingContracts must not be null");
        Assertions.assertFalse((boolean)existingContracts.isEmpty(), (String)"There must be at least one VerifyContract defined");
        VerifyCopyConstructor config = (VerifyCopyConstructor)configOption.get();
        List<PropertyMetadata> filtered = PropertyHelper.handleWhiteAndBlacklistAsList(config.of(), config.exclude(), initialPropertyMetadata);
        Set<String> filteredNames = RuntimeProperties.extractNames(filtered);
        ParameterizedInstantiator<T> sourceInstantiator = CopyConstructorContractImpl.findFittingInstantiator(existingContracts, filteredNames);
        ParameterizedInstantiator<T> copyInstantiator = CopyConstructorContractImpl.createCopyInstantiator(config, beanType);
        return Optional.of(new CopyConstructorContractImpl<T>(copyInstantiator, sourceInstantiator, filteredNames, config.useObjectEquals(), config.verifyDeepCopy(), Arrays.asList(config.verifyDeepCopyIgnore())));
    }

    private static <T> ParameterizedInstantiator<T> createCopyInstantiator(VerifyCopyConstructor config, Class<T> beanType) {
        Class<Object> target = beanType;
        if (!VerifyCopyConstructor.class.equals(config.argumentType())) {
            target = config.argumentType();
        }
        PropertyMetadataImpl meta = PropertyMetadataImpl.builder().name(PROPERTY_NAME_COPY_FROM).generator(new DummyGenerator<T>(target)).propertyClass(target).build();
        return new ConstructorBasedInstantiator<T>(beanType, new RuntimeProperties(CollectionLiterals.immutableList((Object)meta)));
    }

    static <T> ParameterizedInstantiator<T> findFittingInstantiator(List<TestContract<T>> existingContracts, Set<String> filteredNames) {
        for (TestContract<T> contract : existingContracts) {
            Set<String> contractNames = RuntimeProperties.extractNames(contract.getInstantiator().getRuntimeProperties().getAllProperties());
            if (!contractNames.containsAll(filteredNames)) continue;
            return contract.getInstantiator();
        }
        log.warn("No fitting ParameterizedInstantiator found, using best-fit");
        return existingContracts.iterator().next().getInstantiator();
    }

    @Generated
    private CopyConstructorContractImpl(ParameterizedInstantiator<T> copyInstantiator, @NonNull ParameterizedInstantiator<T> instantiator, Set<String> consideredAttributes, boolean useObjectEquals, boolean verifyDeepCopy, Collection<String> verifyDeepCopyIgnore) {
        if (instantiator == null) {
            throw new NullPointerException("instantiator is marked non-null but is null");
        }
        this.copyInstantiator = copyInstantiator;
        this.instantiator = instantiator;
        this.consideredAttributes = consideredAttributes;
        this.useObjectEquals = useObjectEquals;
        this.verifyDeepCopy = verifyDeepCopy;
        this.verifyDeepCopyIgnore = verifyDeepCopyIgnore;
    }

    @Override
    @NonNull
    @Generated
    public ParameterizedInstantiator<T> getInstantiator() {
        return this.instantiator;
    }
}

