/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.contract;

import de.cuioss.test.valueobjects.api.TestContract;
import de.cuioss.test.valueobjects.api.contracts.VerifyBuilder;
import de.cuioss.test.valueobjects.objects.BuilderInstantiator;
import de.cuioss.test.valueobjects.objects.ParameterizedInstantiator;
import de.cuioss.test.valueobjects.objects.RuntimeProperties;
import de.cuioss.test.valueobjects.objects.impl.BuilderConstructorBasedInstantiator;
import de.cuioss.test.valueobjects.objects.impl.BuilderFactoryBasedInstantiator;
import de.cuioss.test.valueobjects.objects.impl.BuilderParameterizedInstantiator;
import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.test.valueobjects.property.PropertySupport;
import de.cuioss.test.valueobjects.util.AnnotationHelper;
import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.reflect.MoreReflection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BuilderContractImpl<T>
implements TestContract<T> {
    private static final CuiLogger log = new CuiLogger(BuilderContractImpl.class);
    private final BuilderInstantiator<T> builderInstantiator;
    private final RuntimeProperties runtimeProperties;
    public static final String DEFAULT_BUILD_METHOD_NAME = "build";
    public static final String DEFAULT_BUILDER_FACTORY_METHOD_NAME = "builder";

    public BuilderContractImpl(BuilderInstantiator<T> instantiator, RuntimeProperties runtimeProperties) {
        this.builderInstantiator = Objects.requireNonNull(instantiator, "builderInstantiator must not be null");
        this.runtimeProperties = Objects.requireNonNull(runtimeProperties, "runtimeProperties must not be null.");
    }

    @Override
    public void assertContract() {
        StringBuilder builder = new StringBuilder("Verifying ");
        builder.append(this.getClass().getName()).append("\nWith configuration: ").append(this.builderInstantiator.toString());
        log.info(builder.toString());
        this.setAndVerifyProperties(this.runtimeProperties.getRequiredProperties());
        this.setAndVerifyProperties(this.runtimeProperties.getAllProperties());
        this.shouldFailOnMissingRequiredAttributes();
    }

    private void setAndVerifyProperties(List<PropertyMetadata> propertiesToBeChecked) {
        List<PropertySupport> properties = propertiesToBeChecked.stream().map(PropertySupport::new).toList();
        properties.forEach(PropertySupport::generateTestValue);
        Object builder = this.builderInstantiator.newBuilderInstance();
        for (PropertySupport support : properties) {
            support.apply(builder);
        }
        T built = this.builderInstantiator.build(builder);
        for (PropertySupport support : properties) {
            if (!support.isReadable()) continue;
            support.assertValueSet(built);
        }
    }

    private void shouldFailOnMissingRequiredAttributes() {
        if (this.runtimeProperties.getRequiredProperties().isEmpty()) {
            return;
        }
        for (PropertyMetadata property : this.runtimeProperties.getRequiredProperties()) {
            List requiredMinusOne = CollectionLiterals.mutableList(this.runtimeProperties.getRequiredProperties());
            requiredMinusOne.remove(property);
            boolean failed = false;
            try {
                this.setAndVerifyProperties(requiredMinusOne);
                failed = true;
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
            if (failed) {
                throw new AssertionError((Object)("Property is marked as required but the builder accepts if it is missing: " + property.toString()));
            }
        }
    }

    @Override
    public ParameterizedInstantiator<T> getInstantiator() {
        return new BuilderParameterizedInstantiator<T>(this.builderInstantiator, this.runtimeProperties);
    }

    public static final <T> Optional<BuilderContractImpl<T>> createBuilderTestContract(Class<T> beanType, Class<?> annotated, List<PropertyMetadata> initialPropertyMetadata) {
        Objects.requireNonNull(beanType, "beantype must not be null");
        Objects.requireNonNull(annotated, "annotated must not be null");
        Objects.requireNonNull(initialPropertyMetadata, "initialPropertyMetadata must not be null");
        Optional config = MoreReflection.extractAnnotation(annotated, VerifyBuilder.class);
        if (config.isEmpty()) {
            log.debug("No annotation of type BuilderTestContract available on class: " + annotated);
            return Optional.empty();
        }
        List<PropertyMetadata> metadata = AnnotationHelper.handleMetadataForBuilderTest(annotated, initialPropertyMetadata);
        VerifyBuilder contract = (VerifyBuilder)config.get();
        BuilderInstantiator instantiator = VerifyBuilder.class.equals(contract.builderClass()) ? (VerifyBuilder.class.equals(contract.builderFactoryProvidingClass()) ? new BuilderFactoryBasedInstantiator(beanType, contract.builderFactoryMethodName(), contract.builderMethodName()) : new BuilderFactoryBasedInstantiator(contract.builderFactoryProvidingClass(), contract.builderFactoryMethodName(), contract.builderMethodName())) : new BuilderConstructorBasedInstantiator(contract.builderClass(), contract.builderMethodName());
        return Optional.of(new BuilderContractImpl(instantiator, new RuntimeProperties(metadata)));
    }
}

