/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.junit.parameterized;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.generator.junit.parameterized.AbstractTypedGeneratorArgumentsProvider;
import de.cuioss.test.generator.junit.parameterized.CompositeTypeGeneratorSource;
import de.cuioss.test.generator.junit.parameterized.GeneratorMethodResolver;
import de.cuioss.test.generator.junit.parameterized.GeneratorType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.JUnitException;

public class CompositeTypeGeneratorArgumentsProvider
extends AbstractTypedGeneratorArgumentsProvider
implements AnnotationConsumer<CompositeTypeGeneratorSource> {
    private Class<? extends TypedGenerator<?>>[] generatorClasses;
    private String[] generatorMethods;
    private GeneratorType[] generators;
    private int count;
    private boolean cartesianProduct;

    public void accept(CompositeTypeGeneratorSource annotation) {
        this.generatorClasses = annotation.generatorClasses();
        this.generatorMethods = annotation.generatorMethods();
        this.generators = annotation.generators();
        this.count = Math.max(1, annotation.count());
        this.cartesianProduct = annotation.cartesianProduct();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Stream<? extends Arguments> provideArgumentsForGenerators(ExtensionContext context) {
        void var5_14;
        void var5_12;
        void var5_10;
        if (this.generatorClasses.length == 0 && this.generatorMethods.length == 0 && this.generators.length == 0) {
            throw new JUnitException("At least one generator class, method, or type must be specified");
        }
        ArrayList generatorInstances = new ArrayList();
        Class<? extends TypedGenerator<?>>[] classArray = this.generatorClasses;
        int n = classArray.length;
        boolean bl = false;
        while (var5_10 < n) {
            Class<? extends TypedGenerator<?>> generatorClass = classArray[var5_10];
            generatorInstances.add(this.createGeneratorInstance(generatorClass));
            ++var5_10;
        }
        String[] stringArray = this.generatorMethods;
        n = stringArray.length;
        boolean bl2 = false;
        while (var5_12 < n) {
            String methodName = stringArray[var5_12];
            generatorInstances.add(GeneratorMethodResolver.getGenerator(methodName, context));
            ++var5_12;
        }
        GeneratorType[] generatorTypeArray = this.generators;
        n = generatorTypeArray.length;
        boolean bl3 = false;
        while (var5_14 < n) {
            GeneratorType generatorType = generatorTypeArray[var5_14];
            generatorInstances.add(this.createGeneratorFromType(generatorType));
            ++var5_14;
        }
        ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
        for (TypedGenerator typedGenerator : generatorInstances) {
            ArrayList values = new ArrayList();
            for (int i = 0; i < this.count; ++i) {
                values.add(typedGenerator.next());
            }
            arrayList.add(values);
        }
        return this.createArgumentsCombinations(arrayList);
    }

    @Override
    protected long getSeed() {
        return -1L;
    }

    @Override
    protected int getCount() {
        return this.count;
    }

    private Stream<Arguments> createArgumentsCombinations(List<List<Object>> generatedValues) {
        if (generatedValues.isEmpty()) {
            return Stream.empty();
        }
        if (this.cartesianProduct) {
            return this.createCartesianProduct(generatedValues);
        }
        return this.createOneToOnePairs(generatedValues);
    }

    private Stream<Arguments> createCartesianProduct(List<List<Object>> generatedValues) {
        ArrayList combinations = new ArrayList();
        combinations.add(new ArrayList());
        for (List<Object> values : generatedValues) {
            ArrayList newCombinations = new ArrayList();
            for (List list : combinations) {
                for (Object value : values) {
                    ArrayList<Object> newCombination = new ArrayList<Object>(list);
                    newCombination.add(value);
                    newCombinations.add(newCombination);
                }
            }
            combinations = newCombinations;
        }
        return combinations.stream().map(combination -> Arguments.of((Object[])combination.toArray()));
    }

    private Stream<Arguments> createOneToOnePairs(List<List<Object>> generatedValues) {
        int size = generatedValues.getFirst().size();
        for (List<Object> values : generatedValues) {
            if (values.size() == size) continue;
            throw new JUnitException("When cartesianProduct is false, all generators must produce the same number of values");
        }
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        for (int i = 0; i < size; ++i) {
            Object[] args = new Object[generatedValues.size()];
            for (int j = 0; j < generatedValues.size(); ++j) {
                args[j] = generatedValues.get(j).get(i);
            }
            arguments.add(Arguments.of((Object[])args));
        }
        return arguments.stream();
    }

    private TypedGenerator<?> createGeneratorFromType(GeneratorType generatorType) {
        try {
            String methodName = generatorType.getMethodName();
            Method method = Generators.class.getMethod(methodName, new Class[0]);
            return (TypedGenerator)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new JUnitException("Failed to create generator from type: " + String.valueOf((Object)generatorType), (Throwable)e);
        }
    }
}

