/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.support;

import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.IntegerGenerator;
import java.util.Objects;

public class SubstringGenerator
implements Generator<String> {
    private final String superstring;
    private final Generator<Integer> sizes;

    public SubstringGenerator(String superstring, int minSize, int maxSize) {
        Objects.requireNonNull(superstring, "superstring");
        if (minSize < 0) {
            throw new IllegalArgumentException("minSize must be >= 0");
        }
        if (superstring.length() < maxSize) {
            throw new IllegalArgumentException("superstring.length() must be >= maxSize");
        }
        this.superstring = superstring;
        this.sizes = new IntegerGenerator(minSize, maxSize);
    }

    @Override
    public String next() {
        int size = this.sizes.next();
        int space = this.superstring.length() - size;
        assert (space >= 0);
        Integer offset = new IntegerGenerator(0, space).next();
        String substring = this.superstring.substring(offset, offset + size);
        assert (substring.length() == size);
        return substring;
    }
}

