/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.support;

import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.IntegerGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SubsetGenerator<T>
implements Generator<Set<T>> {
    private final List<T> superset;
    private final Generator<Integer> sizes;

    public SubsetGenerator(Iterable<T> superset, Generator<Integer> size) {
        Objects.requireNonNull(superset, "superset");
        Objects.requireNonNull(size, "size");
        ArrayList<T> list = new ArrayList<T>();
        superset.forEach(list::add);
        this.superset = list;
        this.sizes = size;
    }

    public SubsetGenerator(Iterable<T> superset) {
        Objects.requireNonNull(superset, "superset");
        ArrayList<T> list = new ArrayList<T>();
        superset.forEach(list::add);
        this.superset = list;
        this.sizes = new IntegerGenerator(0, list.size());
    }

    @Override
    public Set<T> next() {
        Collections.shuffle(this.superset);
        int size = this.sizes.next();
        if (size < 0) {
            throw new IllegalArgumentException("Size must be non-negative");
        }
        if (SubsetGenerator.maxSize(this.superset) < size) {
            throw new IllegalArgumentException("Size must not exceed superset size");
        }
        return new HashSet<T>(this.superset.subList(0, size));
    }

    private static <T> int maxSize(Collection<T> superset) {
        return superset.size();
    }
}

