/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.support;

import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.IntegerGenerator;
import java.util.Iterator;
import java.util.Objects;

public class IteratorGenerator<T>
implements Generator<Iterator<T>> {
    public static final int MIN_SIZE = 0;
    public static final int MAX_SIZE = 10;
    private final Generator<? extends T> content;
    private final Generator<Integer> size;

    public IteratorGenerator(Generator<? extends T> content) {
        this(content, 0, 10);
    }

    public IteratorGenerator(Generator<? extends T> content, int min, int max) {
        this(content, new IntegerGenerator(min, max));
    }

    public IteratorGenerator(Generator<? extends T> content, Generator<Integer> size) {
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(size, "size");
        this.content = content;
        this.size = size;
    }

    @Override
    public Iterator<T> next() {
        final int localSize = Math.max(0, this.size.next());
        return new Iterator<T>(){
            private int i;

            @Override
            public boolean hasNext() {
                return this.i < localSize;
            }

            @Override
            public T next() {
                ++this.i;
                return IteratorGenerator.this.content.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported.");
            }
        };
    }
}

