/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.support;

import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class CloningGenerator<T>
implements Generator<T> {
    private final T prototype;

    public CloningGenerator(T prototype) {
        this.prototype = prototype;
    }

    @Override
    public T next() {
        try {
            return this.cloneObject();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("prototype " + String.valueOf(this.prototype) + " not serializable.", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("this should not happen " + e.getMessage(), e);
        }
    }

    private T cloneObject() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bytesStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(bytesStream);
        objectOutputStream.writeObject(this.prototype);
        objectOutputStream.flush();
        objectOutputStream.close();
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(bytesStream.toByteArray()));
        return this.castObjectToT(objectInputStream);
    }

    private T castObjectToT(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        return (T)objectInputStream.readObject();
    }
}

