/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.support;

import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.distribution.Distribution;
import java.math.BigDecimal;
import java.math.RoundingMode;

abstract class AbstractNumberGenerator<T>
implements Generator<T> {
    private final Distribution distribution;
    private final long min;
    private final long max;
    private final long range;

    AbstractNumberGenerator(long min, long max, Distribution dist) {
        if (max < min) {
            throw new IllegalArgumentException("min <= max");
        }
        this.min = min;
        this.max = max;
        this.range = max - min;
        this.distribution = dist;
    }

    long nextLong() {
        return this.isLongOverflow() ? this.bigDecimalImpl() : this.longImpl();
    }

    private boolean isLongOverflow() {
        return this.range < 0L;
    }

    private long longImpl() {
        return this.min + (long)Math.floor(this.distribution.nextRandomNumber() * ((double)this.range + 1.0));
    }

    private long bigDecimalImpl() {
        BigDecimal localRange = BigDecimal.valueOf(this.max).add(BigDecimal.valueOf(1L)).subtract(BigDecimal.valueOf(this.min));
        return BigDecimal.valueOf(this.min).add(BigDecimal.valueOf(this.distribution.nextRandomNumber()).multiply(localRange)).setScale(0, RoundingMode.FLOOR).longValue();
    }
}

