/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.distribution;

import java.util.Random;

public final class RandomConfiguration {
    public static final String SEED_SYSTEM_PROPERTY = "de.cuioss.test.generator.seed";
    static final Random random = new Random();
    static long lastSeed = 0L;

    private RandomConfiguration() {
    }

    public static long initSeed() {
        long seed = random.nextLong();
        RandomConfiguration.setSeed(seed);
        return seed;
    }

    public static void setSeed(long seed) {
        lastSeed = seed;
        random.setSeed(seed);
    }

    public static long getLastSeed() {
        return lastSeed;
    }

    static void readSystemProperty() {
        String seed = System.getProperty(SEED_SYSTEM_PROPERTY);
        if (seed == null) {
            return;
        }
        RandomConfiguration.setSeed(Long.parseLong(seed));
    }

    static {
        RandomConfiguration.readSystemProperty();
    }
}

