/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck;

import de.cuioss.test.generator.internal.net.java.quickcheck.Characteristic;
import de.cuioss.test.generator.internal.net.java.quickcheck.CharacteristicException;
import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.GeneratorException;
import de.cuioss.test.generator.internal.net.java.quickcheck.GuardException;
import de.cuioss.test.generator.internal.net.java.quickcheck.Runner;
import java.io.PrintWriter;
import java.util.Objects;

class RunnerImpl<T>
implements Runner<T> {
    private int maxRuns;
    private int currentRuns;
    private int runs;
    private final PrintWriter writer;
    private final Characteristic<T> characteristic;
    private final Generator<T> generator;

    public RunnerImpl(Characteristic<T> characteristic, int runs, Generator<T> generator, PrintWriter writer) {
        this.characteristic = characteristic;
        this.generator = generator;
        this.writer = writer;
        this.setRuns(runs);
    }

    @Override
    public void forAll() {
        Objects.requireNonNull(this.characteristic, "characteristic");
        Objects.requireNonNull(this.generator, "generator");
        for (int count = 0; count < this.runs; ++count) {
            try {
                this.doSetup();
                this.check(this.generator);
                continue;
            }
            finally {
                this.doTearDown();
            }
        }
    }

    private void check(Generator<T> generator) {
        Objects.requireNonNull(generator, "generator");
        while (this.currentRuns < this.maxRuns) {
            ++this.currentRuns;
            T value = generator.next();
            this.printCurrentValue(this.currentRuns, value);
            try {
                this.characteristic.specify(value);
                return;
            }
            catch (GuardException e) {
                this.print("%d: skipped [%s]".formatted(this.currentRuns, value));
            }
            catch (Throwable e) {
                this.throwFailedException(value, e, this.characteristic, this.currentRuns);
            }
        }
        String message = "Generator max tries (%s) reached. Check your guard expressions.".formatted(this.maxRuns);
        throw new GeneratorException(message, generator);
    }

    public static int getMaxGeneratorTries(int maxRuns) {
        return maxRuns * 10;
    }

    private void doTearDown() {
        try {
            this.characteristic.tearDown();
        }
        catch (Exception e) {
            throw new CharacteristicException("teardown failed", e, this.characteristic);
        }
    }

    private void doSetup() {
        try {
            this.characteristic.setUp();
        }
        catch (Exception e) {
            throw new CharacteristicException("setup failed", e, this.characteristic);
        }
    }

    private void print(String msg) {
        this.writer.println(msg);
        this.writer.flush();
    }

    private void printCurrentValue(int currentRuns, T value) {
        this.print("%s:[%s]".formatted(currentRuns, value));
    }

    private void throwFailedException(T value, Throwable e, Characteristic<?> characteristic, int currentRuns) {
        String characteristicName = characteristic.name() == null ? "" : characteristic.name();
        String message = "Characteristic %s is not true for value(# %s):[%s] message: >%s<";
        String msg = message.formatted(characteristicName, currentRuns, value, e.getMessage());
        this.print(msg);
        throw new CharacteristicException(msg, e, characteristic, value);
    }

    private void setRuns(int runs) {
        if (1 > runs) {
            throw new IllegalArgumentException("runs");
        }
        this.maxRuns = 10 * runs;
        this.runs = runs;
    }
}

