/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.domain;

import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.generator.domain.EmailGenerator;
import de.cuioss.test.generator.domain.NameGenerators;
import de.cuioss.test.generator.domain.OrganizationNameGenerator;
import de.cuioss.test.generator.domain.Person;
import de.cuioss.test.generator.domain.TitleGenerator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PersonGenerator
implements TypedGenerator<Person> {
    private static final Logger LOGGER = Logger.getLogger(PersonGenerator.class.getName());
    private final TypedGenerator<String> firstNames = NameGenerators.FIRSTNAMES_ANY_ENGLISH.generator();
    private final TypedGenerator<String> familyNames = NameGenerators.FAMILY_NAMES_ENGLISH.generator();
    private final TypedGenerator<String> organizations = OrganizationNameGenerator.READABLE.generator();
    private final TypedGenerator<String> titles = TitleGenerator.READABLE.generator();

    @Override
    public Person next() {
        String firstname = this.firstNames.next();
        String lastname = this.familyNames.next();
        String organization = this.organizations.next();
        String title = this.titles.next();
        if (null == firstname || null == lastname) {
            LOGGER.log(Level.WARNING, "Generated null name components: firstname={0}, lastname={1}", new Object[]{firstname, lastname});
        }
        Person person = Person.builder().email(EmailGenerator.createEmail(firstname, lastname)).firstname(firstname).lastname(lastname).organisation(organization).title(title).build();
        LOGGER.log(Level.FINE, "Generated person: {0} {1}", new Object[]{firstname, lastname});
        return person;
    }
}

