/*
 * Copyright © 2025 CUI-OpenSource-Software (info@cuioss.de)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck;

/**
 * Generator which depends upon other generator instances. After creation new
 * input generators could be added.
 *
 * @param <I> type of input generator
 * @param <T> type of generated values
 *
 */
public interface ExtendibleGenerator<I, T> extends Generator<T> {

    /**
     * Add a new generator.
     *
     * @return this generator instance
     */
    ExtendibleGenerator<I, T> add(Generator<I> newGenerator);
}
