/*
 * Copyright © 2025 CUI-OpenSource-Software (info@cuioss.de)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck;

/**
 * <p>
 * A characteristic specifies an aspect of a system under test.
 * </p>
 * <p>
 * The characteristic stated is tested with a number of test data instances
 * generated by a generator. All runs of a characteristic's
 * {@link Characteristic#specify(Object)} method have to be valid. Invalid runs
 * have to throw an exception.
 * </p>
 *
 * @param <T> type of generated random test instances
 *
 */
@SuppressWarnings("ProhibitedExceptionDeclared")
public interface Characteristic<T> {

    /**
     * Checks the characteristic's specification for a test case instance.
     *
     * @param instance for which to check the characteristic
     * @throws Throwable if the instance does not confirm to the characteristic's
     *                   specification
     */
    void specify(T instance) throws Throwable;

    /**
     * Set up operation before {@link Characteristic#specify(Object)} is executed.
     */
    void setUp() throws Exception;

    /**
     * Clean up operation after {@link Characteristic#specify(Object)} was executed.
     */
    void tearDown() throws Exception;

    /**
     * Unique name for this characteristic instance.
     *
     * @return name of the characteristic.
     */
    String name();
}
