/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.junit.parameterized;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.generator.junit.parameterized.AbstractTypedGeneratorArgumentsProvider;
import de.cuioss.test.generator.junit.parameterized.GeneratorParameterType;
import de.cuioss.test.generator.junit.parameterized.GeneratorType;
import de.cuioss.test.generator.junit.parameterized.GeneratorsSource;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.JUnitException;

public class GeneratorsSourceArgumentsProvider
extends AbstractTypedGeneratorArgumentsProvider
implements AnnotationConsumer<GeneratorsSource> {
    private GeneratorType generatorType;
    private int minSize;
    private int maxSize;
    private String low;
    private String high;
    private int count;

    public void accept(GeneratorsSource annotation) {
        this.generatorType = annotation.generator();
        this.minSize = annotation.minSize();
        this.maxSize = annotation.maxSize();
        this.low = annotation.low();
        this.high = annotation.high();
        this.count = Math.max(1, annotation.count());
    }

    @Override
    protected Stream<? extends Arguments> provideArgumentsForGenerators(ExtensionContext context) {
        TypedGenerator<?> generator;
        try {
            generator = this.createGeneratorFromFactory();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        return this.generateArguments(generator).stream();
    }

    @Override
    protected long getSeed() {
        return -1L;
    }

    @Override
    protected int getCount() {
        return this.count;
    }

    private TypedGenerator<?> createGeneratorFromFactory() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Objects.requireNonNull(this.generatorType, "Generator type must not be null");
        if (this.isDomainSpecificGenerator()) {
            return this.createDomainSpecificGenerator();
        }
        String methodName = this.generatorType.getMethodName();
        Objects.requireNonNull(methodName, "Generator method name must not be null");
        return switch (this.generatorType.getParameterType()) {
            default -> throw new IncompatibleClassChangeError();
            case GeneratorParameterType.NEEDS_BOUNDS -> this.createStringGenerator();
            case GeneratorParameterType.NEEDS_RANGE -> this.createNumberGenerator();
            case GeneratorParameterType.PARAMETERLESS -> this.createParameterlessGenerator();
        };
    }

    private boolean isDomainSpecificGenerator() {
        return this.generatorType.getMethodName() == null && this.generatorType.getFactoryClass() != null && TypedGenerator.class.isAssignableFrom(this.generatorType.getFactoryClass());
    }

    private TypedGenerator<?> createDomainSpecificGenerator() throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?> generatorClass = this.generatorType.getFactoryClass();
        Constructor<?> constructor = generatorClass.getDeclaredConstructor(new Class[0]);
        return (TypedGenerator)constructor.newInstance(new Object[0]);
    }

    private TypedGenerator<?> createStringGenerator() throws InvocationTargetException, IllegalAccessException {
        Method method = this.findMethodWithParameters(this.generatorType.getMethodName(), Integer.TYPE, Integer.TYPE);
        return (TypedGenerator)method.invoke(null, this.minSize, this.maxSize);
    }

    private TypedGenerator<?> createNumberGenerator() throws InvocationTargetException, IllegalAccessException {
        Object[] params;
        Class[] paramTypes;
        Class<?> returnType = this.generatorType.getReturnType();
        if (Integer.class.equals(returnType)) {
            paramTypes = new Class[]{Integer.TYPE, Integer.TYPE};
            params = new Object[]{Integer.parseInt(this.low), Integer.parseInt(this.high)};
        } else if (Long.class.equals(returnType)) {
            paramTypes = new Class[]{Long.TYPE, Long.TYPE};
            params = new Object[]{Long.parseLong(this.low), Long.parseLong(this.high)};
        } else if (Double.class.equals(returnType)) {
            paramTypes = new Class[]{Double.TYPE, Double.TYPE};
            params = new Object[]{Double.parseDouble(this.low), Double.parseDouble(this.high)};
        } else if (Float.class.equals(returnType)) {
            paramTypes = new Class[]{Float.TYPE, Float.TYPE};
            params = new Object[]{Float.valueOf(Float.parseFloat(this.low)), Float.valueOf(Float.parseFloat(this.high))};
        } else if (Short.class.equals(returnType)) {
            paramTypes = new Class[]{Short.TYPE, Short.TYPE};
            params = new Object[]{Short.parseShort(this.low), Short.parseShort(this.high)};
        } else if (Byte.class.equals(returnType)) {
            paramTypes = new Class[]{Byte.TYPE, Byte.TYPE};
            params = new Object[]{Byte.parseByte(this.low), Byte.parseByte(this.high)};
        } else {
            throw new UnsupportedOperationException("Number generator for type '" + returnType.getSimpleName() + "' is not supported.");
        }
        Method method = this.findMethodWithParameters(this.generatorType.getMethodName(), paramTypes);
        return (TypedGenerator)method.invoke(null, params);
    }

    private TypedGenerator<?> createParameterlessGenerator() throws InvocationTargetException, IllegalAccessException {
        Method method = this.findMethodWithParameters(this.generatorType.getMethodName(), new Class[0]);
        return (TypedGenerator)method.invoke(null, new Object[0]);
    }

    private Method findMethodWithParameters(String methodName, Class<?> ... parameterTypes) {
        try {
            return Generators.class.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new JUnitException("Could not find static generator method '" + methodName + "' in Generators class with the specified parameter types", (Throwable)e);
        }
    }
}

