/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.support;

import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.ObjectDefinition;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

class ObjectFactory<T>
implements InvocationHandler {
    private final ObjectDefinition<T> definition;

    ObjectFactory(ObjectDefinition<T> definition) {
        this.definition = definition;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        return this.definition.retrieveMapping(method).next();
    }

    private void checkAllMethodsAreDefined() {
        for (Method method : this.definition.getType().getMethods()) {
            if (method.getReturnType().equals(Void.TYPE) || this.definition.retrieveMapping(method) != null) continue;
            String message = "Definition for method %s missing.".formatted(method.getName());
            throw new IllegalStateException(message);
        }
    }

    T newValue() {
        this.checkAllMethodsAreDefined();
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.definition.getType()}, (InvocationHandler)this);
    }
}

