/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.support;

import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.AbstractTransformerGenerator;
import java.lang.reflect.Array;

abstract class AbstractPrimitiveArrayGenerator<I, P>
extends AbstractTransformerGenerator<I, P> {
    private final Class<?> componentType;

    AbstractPrimitiveArrayGenerator(Generator<I> inputGenerator, Class<?> componentType) {
        super(inputGenerator);
        this.componentType = componentType;
    }

    @Override
    protected P transform(Generator<I> inputGenerator) {
        I objectArray = inputGenerator.next();
        P primitive = this.createPrimitiveArray(objectArray);
        for (int i = 0; i < Array.getLength(objectArray); ++i) {
            Array.set(primitive, i, Array.get(objectArray, i));
        }
        return primitive;
    }

    private P createPrimitiveArray(I objectArray) {
        return (P)Array.newInstance(this.componentType, Array.getLength(objectArray));
    }
}

