/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.domain;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.generator.domain.NameGenerators;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.string.MoreStrings;

public class EmailGenerator
implements TypedGenerator<String> {
    private static final CuiLogger LOGGER = new CuiLogger(EmailGenerator.class);
    private final TypedGenerator<String> firstNames = NameGenerators.FIRSTNAMES_ANY_ENGLISH.generator();
    private final TypedGenerator<String> familyNames = NameGenerators.FAMILY_NAMES_ENGLISH.generator();
    private static final TypedGenerator<String> TLDS = Generators.fixedValues("de", "org", "com", "net");
    private static final TypedGenerator<String> DOMAINS = Generators.fixedValues("email", "mail", "cuioss", "message", "example", "hospital");

    @Override
    public String next() {
        return EmailGenerator.createEmail(this.firstNames.next(), this.familyNames.next());
    }

    public static String createEmail(String firstname, String lastname) {
        if (MoreStrings.isBlank((CharSequence)firstname) || MoreStrings.isBlank((CharSequence)lastname)) {
            LOGGER.warn("Invalid name components for email generation: firstname='%s', lastname='%s'", new Object[]{firstname, lastname});
            return "invalid.email@example.com";
        }
        String email = (firstname + "." + lastname + "@" + DOMAINS.next()).toLowerCase();
        LOGGER.debug("Generated email: %s", new Object[]{email + "." + TLDS.next()});
        return email + "." + TLDS.next();
    }
}

