/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.junit.parameterized;

import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.generator.junit.parameterized.AbstractTypedGeneratorArgumentsProvider;
import de.cuioss.test.generator.junit.parameterized.TypeGeneratorSource;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.support.AnnotationConsumer;

public class TypeGeneratorArgumentsProvider
extends AbstractTypedGeneratorArgumentsProvider
implements AnnotationConsumer<TypeGeneratorSource> {
    private Class<? extends TypedGenerator<?>> generatorClass;
    private int count;
    private long seed;

    public void accept(TypeGeneratorSource annotation) {
        this.generatorClass = annotation.value();
        this.count = Math.max(1, annotation.count());
        this.seed = annotation.seed();
    }

    @Override
    protected Stream<? extends Arguments> provideArgumentsForGenerators(ExtensionContext context) {
        TypedGenerator<?> generator = this.createGeneratorInstance(this.generatorClass);
        return this.generateArguments(generator).stream();
    }

    @Override
    protected long getSeed() {
        return this.seed;
    }

    @Override
    protected int getCount() {
        return this.count;
    }
}

