/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.junit.parameterized;

import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.generator.junit.parameterized.AbstractTypedGeneratorArgumentsProvider;
import de.cuioss.test.generator.junit.parameterized.CompositeTypeGeneratorSource;
import de.cuioss.test.generator.junit.parameterized.GeneratorMethodResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.JUnitException;

public class CompositeTypeGeneratorArgumentsProvider
extends AbstractTypedGeneratorArgumentsProvider
implements AnnotationConsumer<CompositeTypeGeneratorSource> {
    private Class<? extends TypedGenerator<?>>[] generatorClasses;
    private String[] generatorMethods;
    private int count;
    private boolean cartesianProduct;
    private long seed;

    public void accept(CompositeTypeGeneratorSource annotation) {
        this.generatorClasses = annotation.generatorClasses();
        this.generatorMethods = annotation.generatorMethods();
        this.count = Math.max(1, annotation.count());
        this.cartesianProduct = annotation.cartesianProduct();
        this.seed = annotation.seed();
        if (this.seed == 0L) {
            this.seed = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Stream<? extends Arguments> provideArgumentsForGenerators(ExtensionContext context) {
        void var5_9;
        void var5_7;
        if (this.generatorClasses.length == 0 && this.generatorMethods.length == 0) {
            throw new JUnitException("At least one generator class or method must be specified");
        }
        ArrayList generators = new ArrayList();
        Object[] objectArray = this.generatorClasses;
        int n = objectArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            Class<? extends TypedGenerator<?>> generatorClass = objectArray[var5_7];
            generators.add(this.createGeneratorInstance(generatorClass));
            ++var5_7;
        }
        objectArray = this.generatorMethods;
        n = objectArray.length;
        boolean bl2 = false;
        while (var5_9 < n) {
            Object methodName = objectArray[var5_9];
            generators.add(GeneratorMethodResolver.getGenerator((String)methodName, context));
            ++var5_9;
        }
        ArrayList<List<Object>> generatedValues = new ArrayList<List<Object>>();
        for (TypedGenerator typedGenerator : generators) {
            ArrayList values = new ArrayList();
            for (int i = 0; i < this.count; ++i) {
                values.add(typedGenerator.next());
            }
            generatedValues.add(values);
        }
        return this.createArgumentsCombinations(generatedValues);
    }

    @Override
    protected long getSeed() {
        return this.seed;
    }

    @Override
    protected int getCount() {
        return this.count;
    }

    private Stream<Arguments> createArgumentsCombinations(List<List<Object>> generatedValues) {
        if (generatedValues.isEmpty()) {
            return Stream.empty();
        }
        if (this.cartesianProduct) {
            return this.createCartesianProduct(generatedValues);
        }
        return this.createOneToOnePairs(generatedValues);
    }

    private Stream<Arguments> createCartesianProduct(List<List<Object>> generatedValues) {
        ArrayList combinations = new ArrayList();
        combinations.add(new ArrayList());
        for (List<Object> values : generatedValues) {
            ArrayList newCombinations = new ArrayList();
            for (List list : combinations) {
                for (Object value : values) {
                    ArrayList<Object> newCombination = new ArrayList<Object>(list);
                    newCombination.add(value);
                    newCombinations.add(newCombination);
                }
            }
            combinations = newCombinations;
        }
        return combinations.stream().map(combination -> Arguments.of((Object[])combination.toArray()));
    }

    private Stream<Arguments> createOneToOnePairs(List<List<Object>> generatedValues) {
        int size = generatedValues.get(0).size();
        for (List<Object> values : generatedValues) {
            if (values.size() == size) continue;
            throw new JUnitException("When cartesianProduct is false, all generators must produce the same number of values");
        }
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        for (int i = 0; i < size; ++i) {
            Object[] args = new Object[generatedValues.size()];
            for (int j = 0; j < generatedValues.size(); ++j) {
                args[j] = generatedValues.get(j).get(i);
            }
            arguments.add(Arguments.of((Object[])args));
        }
        return arguments.stream();
    }
}

