/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.support;

import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.GeneratorException;
import de.cuioss.tools.base.Preconditions;

public abstract class VetoableGenerator<T>
implements Generator<T> {
    private final Generator<? extends T> generator;
    private final int maxTries;
    public static final int DEFAULT_MAX_TRIES = 100;
    public static final int MIN_TRIES = 1;

    protected VetoableGenerator(Generator<? extends T> generator) {
        this(generator, 100);
    }

    protected VetoableGenerator(Generator<? extends T> generator, int maxTries) {
        Preconditions.checkArgument((1 <= maxTries ? 1 : 0) != 0, (String)"maxTries");
        this.generator = generator;
        this.maxTries = maxTries;
    }

    @Override
    public T next() throws GeneratorException {
        for (int idx = 0; idx < this.maxTries; ++idx) {
            T value = this.generator.next();
            if (!this.tryValue(value)) continue;
            return value;
        }
        throw new GeneratorException("Failed to generate another value after [%s] tries (generator: %s)".formatted(this.maxTries, this.generator), this.generator);
    }

    protected abstract boolean tryValue(T var1);
}

