/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.support;

import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.IntegerGenerator;
import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.collect.CollectionLiterals;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SubsetGenerator<T>
implements Generator<Set<T>> {
    private final List<T> superset;
    private final Generator<Integer> sizes;

    public SubsetGenerator(Iterable<T> superset, Generator<Integer> size) {
        Objects.requireNonNull(superset, "superset");
        Objects.requireNonNull(size, "size");
        this.superset = CollectionLiterals.mutableList(superset);
        this.sizes = size;
    }

    public SubsetGenerator(Iterable<T> superset) {
        this(superset, new IntegerGenerator(0, CollectionLiterals.mutableList(superset).size()));
    }

    @Override
    public Set<T> next() {
        Collections.shuffle(this.superset);
        int size = this.sizes.next();
        Preconditions.checkArgument((0 <= size ? 1 : 0) != 0);
        Preconditions.checkArgument((SubsetGenerator.maxSize(this.superset) >= size ? 1 : 0) != 0);
        return new HashSet<T>(this.superset.subList(0, size));
    }

    private static <T> int maxSize(Collection<T> superset) {
        return superset.size();
    }
}

