/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.support;

import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.StatefulGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.iterable.Iterables;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.FixedValuesGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.IntegerGenerator;
import de.cuioss.tools.base.Preconditions;
import java.util.Iterator;
import java.util.Objects;

public class EnsuredValuesGenerator<T>
implements StatefulGenerator<T> {
    private final Iterable<T> ensured;
    private final Generator<T> otherValues;
    private Iterator<T> iterator;
    private final int size;
    private final int window;
    private int valuesLeft;
    private int generatesLeft;

    public EnsuredValuesGenerator(Iterable<T> values) {
        this(values, new FixedValuesGenerator<T>(values));
    }

    public EnsuredValuesGenerator(Iterable<T> ensured, Generator<T> random) {
        this(ensured, Iterables.sizeOf(ensured), random);
    }

    public EnsuredValuesGenerator(Iterable<T> ensured, int window, Generator<T> random) {
        this.size = Iterables.sizeOf(ensured);
        Preconditions.checkArgument((this.size <= window ? 1 : 0) != 0, (String)"window");
        this.window = window;
        Objects.requireNonNull(random, "random");
        this.ensured = ensured;
        this.otherValues = random;
        this.reset();
    }

    @Override
    public T next() {
        return this.takeEnsured() ? this.iterator.next() : this.otherValues.next();
    }

    private boolean takeEnsured() {
        if (this.valuesLeft > 0 && this.spreadOverWindow()) {
            --this.valuesLeft;
            return true;
        }
        --this.generatesLeft;
        return false;
    }

    private boolean spreadOverWindow() {
        assert (this.valuesLeft > 0 && this.generatesLeft >= 0);
        return new IntegerGenerator(0, this.valuesLeft + this.generatesLeft).next() <= this.valuesLeft;
    }

    @Override
    public void reset() {
        this.iterator = this.ensured.iterator();
        this.valuesLeft = this.size;
        this.generatesLeft = this.window - this.size;
        assert (this.generatesLeft >= 0) : this.generatesLeft;
    }
}

