/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.support;

import de.cuioss.test.generator.internal.net.java.quickcheck.FrequencyGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.IntegerGenerator;
import de.cuioss.tools.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DefaultFrequencyGenerator<T>
implements FrequencyGenerator<T> {
    public static final int EQUAL_WEIGHT_OF_GENERATORS = 1;
    private final List<Frequency<T>> frequencies = new ArrayList<Frequency<T>>();
    private IntegerGenerator choose;
    private int sum = 0;

    public DefaultFrequencyGenerator(Generator<T> generator) {
        this(generator, 1);
    }

    public DefaultFrequencyGenerator(Generator<T> generator, int weight) {
        this.add(generator, weight);
    }

    public FrequencyGenerator<T> add(Generator<T> generator) {
        return this.add(generator, 1);
    }

    @Override
    public FrequencyGenerator<T> add(Generator<T> generator, int weight) {
        Objects.requireNonNull(generator, "generator");
        Preconditions.checkArgument((1 <= weight ? 1 : 0) != 0, (String)"weight");
        this.frequencies.add(new Frequency<T>(generator, weight));
        this.sum += weight;
        this.choose = null;
        return this;
    }

    @Override
    public T next() {
        Preconditions.checkArgument((1 <= this.sum ? 1 : 0) != 0, (String)"number of generators");
        int next = this.choose().nextInt();
        for (Frequency<T> pair : this.frequencies) {
            int weight = pair.getWeight();
            if (next <= weight) {
                return pair.getGenerator().next();
            }
            next -= weight;
        }
        throw new IllegalStateException();
    }

    private IntegerGenerator choose() {
        if (this.choose == null) {
            this.choose = new IntegerGenerator(1, this.sum);
        }
        return this.choose;
    }

    private static class Frequency<T> {
        private final Generator<T> generator;
        private final int weight;

        private Frequency(Generator<T> generator, int weight) {
            this.generator = generator;
            this.weight = weight;
        }

        private Generator<T> getGenerator() {
            return this.generator;
        }

        private int getWeight() {
            return this.weight;
        }
    }
}

