/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator;

import de.cuioss.test.generator.internal.net.java.quickcheck.ExtendibleGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.FrequencyGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.ObjectGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.StatefulGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.collection.Pair;
import de.cuioss.test.generator.internal.net.java.quickcheck.collection.Triple;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.distribution.Distribution;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.AbstractTransformerGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.ArrayGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.ByteArrayGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.ByteGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.CharacterGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.CloningGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.DateGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.DefaultFrequencyGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.DoubleGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.DuplicateGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.EnsuredValuesGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.ExcludingGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.FixedValuesGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.IntegerArrayGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.IntegerGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.IteratorGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.ListGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.LongGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.MapGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.ObjectDefaultMappingGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.ObjectGeneratorImpl;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.SetGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.SortedListGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.StrictlyOrderedGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.StringGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.SubmapGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.SubsetGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.SubstringGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.TupleGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.UniqueComparableValuesGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.UniqueValuesGenerator;
import de.cuioss.tools.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class Generators {
    public static final int DEFAULT_STRING_MAX_LENGTH = 30;
    public static final int DEFAULT_COLLECTION_MAX_SIZE = 10;
    public static final int DEFAULT_MAX_TRIES = 100;

    private Generators() {
    }

    public static <T> Generator<T> cast(Generator<? extends T> generator) {
        return generator;
    }

    public static <T> Iterable<T> toIterable(Generator<T> generator) {
        return Generators.toIterable(generator, 200);
    }

    public static <T> Iterable<T> toIterable(final Generator<T> generator, final int numberOfRuns) {
        Objects.requireNonNull(generator, "generator");
        Preconditions.checkArgument((0.0 <= (double)numberOfRuns ? 1 : 0) != 0, (String)"number of runs");
        return () -> new Iterator<T>(){
            private int runs;

            @Override
            public boolean hasNext() {
                return this.runs < numberOfRuns;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.runs;
                return generator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static ExtendibleGenerator<Character, String> strings() {
        return new StringGenerator();
    }

    public static ExtendibleGenerator<Character, String> strings(char lo, char hi) {
        return new StringGenerator(lo, hi);
    }

    public static ExtendibleGenerator<Character, String> strings(String allowedCharacters) {
        return new StringGenerator(Generators.characters(allowedCharacters));
    }

    public static ExtendibleGenerator<Character, String> strings(String allowedCharacters, int min, int max) {
        return new StringGenerator(new IntegerGenerator(min, max), Generators.characters(allowedCharacters));
    }

    public static ExtendibleGenerator<Character, String> strings(int max) {
        return Generators.strings(0, max);
    }

    public static ExtendibleGenerator<Character, String> strings(int min, int max) {
        return new StringGenerator(new IntegerGenerator(min, max), new CharacterGenerator());
    }

    public static ExtendibleGenerator<Character, String> strings(Generator<Integer> length, Generator<Character> characters) {
        return new StringGenerator(length, characters);
    }

    public static ExtendibleGenerator<Character, String> strings(Generator<Character> characterGenerator) {
        return new StringGenerator(characterGenerator);
    }

    public static ExtendibleGenerator<Character, String> letterStrings() {
        return new StringGenerator(Generators.characters('a', 'z')).add(Generators.characters('A', 'Z'));
    }

    public static ExtendibleGenerator<Character, String> letterStrings(int min, int max) {
        StringGenerator generator = new StringGenerator(new IntegerGenerator(min, max), Generators.characters('a', 'z'));
        return generator.add(Generators.characters('A', 'Z'));
    }

    public static ExtendibleGenerator<Character, String> printableStrings() {
        return new StringGenerator(Generators.basicLatinCharacters()).add(Generators.latin1SupplementCharacters());
    }

    public static ExtendibleGenerator<Character, String> nonEmptyStrings() {
        return Generators.strings(1, 30);
    }

    public static Generator<String> substrings(String base) {
        return Generators.substrings(base, 0, base.length());
    }

    public static Generator<String> substrings(String base, int size) {
        return Generators.substrings(base, size, size);
    }

    public static Generator<String> substrings(String base, int minSize, int maxSize) {
        return new SubstringGenerator(base, minSize, maxSize);
    }

    public static Generator<Character> characters(char lo, char hi) {
        return new CharacterGenerator(lo, hi);
    }

    public static Generator<Character> characters() {
        return new CharacterGenerator();
    }

    public static Generator<Character> characters(Character ... chars) {
        return Generators.characters(Arrays.asList(chars));
    }

    public static Generator<Character> characters(String string) {
        Character[] chars = new Character[string.length()];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = Character.valueOf(string.charAt(i));
        }
        return Generators.characters(chars);
    }

    public static Generator<Character> characters(Iterable<Character> chars) {
        return new FixedValuesGenerator<Character>(chars);
    }

    public static Generator<Character> latin1SupplementCharacters() {
        return Generators.characters(CharacterGenerator.LATIN_1_SUPPLEMENT.getFirst().charValue(), CharacterGenerator.LATIN_1_SUPPLEMENT.getSecond().charValue());
    }

    public static Generator<Character> basicLatinCharacters() {
        return Generators.characters(CharacterGenerator.BASIC_LATIN.getFirst().charValue(), CharacterGenerator.BASIC_LATIN.getSecond().charValue());
    }

    public static Generator<Integer> integers() {
        return new IntegerGenerator();
    }

    public static Generator<Integer> integers(int low) {
        return new IntegerGenerator(low, Integer.MAX_VALUE);
    }

    public static Generator<Integer> integers(int lo, int hi) {
        return new IntegerGenerator(lo, hi);
    }

    public static Generator<Integer> integers(int lo, int hi, Distribution distribution) {
        return new IntegerGenerator(lo, hi, distribution);
    }

    public static Generator<Integer> positiveIntegers() {
        return Generators.positiveIntegers(Integer.MAX_VALUE);
    }

    public static Generator<Integer> positiveIntegers(int hi) {
        return new IntegerGenerator(1, hi);
    }

    public static Generator<Byte> bytes() {
        return new ByteGenerator();
    }

    public static Generator<Byte> bytes(byte lo, byte hi) {
        return new ByteGenerator(lo, hi);
    }

    public static Generator<Byte> bytes(byte lo, byte hi, Distribution distribution) {
        return new ByteGenerator(lo, hi, distribution);
    }

    public static Generator<Long> longs() {
        return new LongGenerator();
    }

    public static Generator<Long> longs(long lo, long hi) {
        return new LongGenerator(lo, hi, Distribution.UNIFORM);
    }

    public static Generator<Long> longs(long lo, long hi, Distribution distribution) {
        return new LongGenerator(lo, hi, distribution);
    }

    public static Generator<Long> positiveLongs() {
        return Generators.positiveLongs(Long.MAX_VALUE);
    }

    public static Generator<Long> positiveLongs(long hi) {
        return Generators.longs(1L, hi);
    }

    public static Generator<Double> doubles() {
        return new DoubleGenerator();
    }

    public static Generator<Double> doubles(double lo, double hi) {
        return new DoubleGenerator(lo, hi);
    }

    public static Generator<Double> doubles(double lo, double hi, Distribution distribution) {
        return new DoubleGenerator(lo, hi, distribution);
    }

    public static Generator<Boolean> booleans() {
        return new FixedValuesGenerator<Boolean>(Arrays.asList(Boolean.TRUE, Boolean.FALSE));
    }

    public static <T> Generator<T> nulls() {
        return new FixedValuesGenerator();
    }

    public static Generator<Date> dates() {
        return Generators.dates(TimeUnit.MILLISECONDS);
    }

    public static Generator<Date> dates(TimeUnit precision) {
        return Generators.dates(Long.MIN_VALUE, Long.MAX_VALUE, precision);
    }

    public static Generator<Date> dates(Date low, Date high) {
        return Generators.dates(low.getTime(), high.getTime());
    }

    public static Generator<Date> dates(long low, long high) {
        return Generators.dates(low, high, TimeUnit.MILLISECONDS);
    }

    public static Generator<Date> dates(Long low, Long high, TimeUnit precision) {
        return new DateGenerator(precision, low, high, 100);
    }

    public static <T> Generator<T> fixedValues(T value) {
        return new FixedValuesGenerator<T>(value);
    }

    @SafeVarargs
    public static <T> Generator<T> fixedValues(T ... values) {
        return Generators.fixedValues(Arrays.asList(values));
    }

    public static <T> Generator<T> fixedValues(Iterable<T> values) {
        return new FixedValuesGenerator<T>(values);
    }

    public static <T> Generator<T> clonedValues(T prototype) {
        return new CloningGenerator<T>(prototype);
    }

    public static <T extends Enum<T>> Generator<T> enumValues(Class<T> enumClass) {
        return Generators.enumValues(enumClass, Collections.emptyList());
    }

    @SafeVarargs
    public static <T extends Enum<T>> Generator<T> enumValues(Class<T> enumClass, T ... excluded) {
        return Generators.enumValues(enumClass, Arrays.asList(excluded));
    }

    public static <T extends Enum<T>> Generator<T> enumValues(Class<T> enumClass, Iterable<T> excludedValues) {
        EnumSet<T> excluded = EnumSet.noneOf(enumClass);
        for (Enum e : excludedValues) {
            excluded.add(e);
        }
        return new FixedValuesGenerator<T>(EnumSet.complementOf(excluded));
    }

    public static Generator<Object> objects() {
        return new de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.ObjectGenerator();
    }

    public static <T> ObjectGenerator<T> objects(Class<T> objectType) {
        return new ObjectGeneratorImpl<T>(objectType);
    }

    public static <T> ObjectGenerator<T> defaultObjects(Class<T> objectType) {
        return new ObjectDefaultMappingGenerator<T>(objectType);
    }

    public static <T> FrequencyGenerator<T> frequency(Generator<T> generator, int weight) {
        return new DefaultFrequencyGenerator<T>(generator, weight);
    }

    public static <T> ExtendibleGenerator<T, T> oneOf(Generator<T> generator) {
        return Generators.frequency(generator, 1);
    }

    public static <T> Generator<List<T>> vectors(Generator<T> content, int size) {
        return new ListGenerator<T>(content, new FixedValuesGenerator<Integer>(size));
    }

    public static <A, B> Generator<Pair<A, B>> pairs(Generator<A> first, Generator<B> second) {
        TupleGenerator generator = new TupleGenerator(first, second);
        return () -> {
            Object[] next = generator.next();
            return new Pair<Object, Object>(next[0], next[1]);
        };
    }

    public static <T extends Comparable<T>> Generator<Pair<T, T>> sortedPairs(Generator<T> content) {
        return new AbstractTransformerGenerator<List<T>, Pair<T, T>>(Generators.sortedLists(content, 2, 2)){

            @Override
            protected Pair<T, T> transform(Generator<List<T>> inputGenerator) {
                List next = inputGenerator.next();
                return new Pair<Comparable, Comparable>((Comparable)next.get(0), (Comparable)next.get(1));
            }
        };
    }

    public static <A, B, C> Generator<Triple<A, B, C>> triples(Generator<A> first, Generator<B> second, Generator<C> third) {
        TupleGenerator generator = new TupleGenerator(first, second, third);
        return () -> {
            Object[] next = generator.next();
            return new Triple<Object, Object, Object>(next[0], next[1], next[2]);
        };
    }

    @SafeVarargs
    public static <T> Generator<T> nullsAnd(T ... values) {
        return Generators.nullsAnd(new FixedValuesGenerator<T>(Arrays.asList(values)));
    }

    public static <T extends Comparable<T>> Generator<Triple<T, T, T>> sortedTriple(Generator<T> content) {
        return new AbstractTransformerGenerator<List<T>, Triple<T, T, T>>(Generators.sortedLists(content, 3, 3)){

            @Override
            protected Triple<T, T, T> transform(Generator<List<T>> inputGenerator) {
                List next = inputGenerator.next();
                return new Triple<Comparable, Comparable, Comparable>((Comparable)next.get(0), (Comparable)next.get(1), (Comparable)next.get(2));
            }
        };
    }

    public static <T> Generator<T> nullsAnd(Generator<T> generator) {
        return Generators.nullsAnd(generator, 5);
    }

    public static <T> Generator<T> nullsAnd(Generator<T> generator, int weight) {
        return new DefaultFrequencyGenerator<T>(Generators.nulls(), 1).add(generator, weight);
    }

    public static <T> Generator<Set<T>> sets(Generator<? extends T> content) {
        return new SetGenerator<T>(content);
    }

    public static <T> Generator<Set<T>> sets(Generator<? extends T> content, Generator<Integer> size) {
        return new SetGenerator<T>(content, size, 100);
    }

    public static <T> Generator<Set<T>> sets(Generator<? extends T> content, int low, int high) {
        return new SetGenerator<T>(content, Generators.integers(low, high), 100);
    }

    public static <T> Generator<Set<T>> nonEmptySets(Generator<? extends T> content) {
        return Generators.sets(content, 1, 10);
    }

    @SafeVarargs
    public static <T> Generator<Set<T>> sets(T ... superset) {
        return Generators.sets(Arrays.asList(superset));
    }

    public static <T> Generator<Set<T>> sets(Iterable<T> superset) {
        return new SubsetGenerator<T>(superset);
    }

    public static <T> Generator<Set<T>> sets(Iterable<T> superset, Generator<Integer> size) {
        return new SubsetGenerator<T>(superset, size);
    }

    @SafeVarargs
    public static <T> Generator<List<T>> duplicates(T ... input) {
        return new DuplicateGenerator<T>(Arrays.asList(input));
    }

    public static <T> Generator<List<T>> duplicates(Iterable<T> input) {
        return new DuplicateGenerator<T>(input);
    }

    public static <T> Generator<Iterator<T>> iterators(Generator<? extends T> content) {
        return new IteratorGenerator<T>(content);
    }

    public static <T> Generator<Iterator<T>> nonEmptyIterators(Generator<T> content) {
        return new IteratorGenerator<T>(content, 1, 10);
    }

    public static <T> Generator<Iterator<T>> iterators(Generator<? extends T> content, Generator<Integer> size) {
        return new IteratorGenerator<T>(content, size);
    }

    public static <T> Generator<List<T>> lists(Generator<? extends T> content) {
        return new ListGenerator<T>(content);
    }

    public static <T> Generator<List<T>> nonEmptyLists(Generator<? extends T> content) {
        return Generators.lists(content, Generators.positiveIntegers(10));
    }

    public static <T> Generator<List<T>> lists(Generator<? extends T> content, Generator<Integer> size) {
        return new ListGenerator<T>(content, size);
    }

    public static <T> Generator<List<T>> lists(Generator<? extends T> content, int low, int high) {
        return Generators.lists(content, new IntegerGenerator(low, high));
    }

    public static <T> Generator<List<T>> lists(Generator<? extends T> content, int low) {
        return Generators.lists(content, low, Math.max(low, 10));
    }

    public static <T extends Comparable<T>> Generator<List<T>> sortedLists(Generator<T> content) {
        return new SortedListGenerator<T>(content);
    }

    public static <T extends Comparable<T>> Generator<List<T>> sortedLists(Generator<T> content, int low, int high) {
        return Generators.sortedLists(content, Generators.integers(low, high));
    }

    public static <T extends Comparable<T>> Generator<List<T>> sortedLists(Generator<T> content, Generator<Integer> size) {
        return new SortedListGenerator<T>(content, size);
    }

    public static <T> Generator<T[]> arrays(Generator<? extends T> content, Class<T> type) {
        return new ArrayGenerator<T>(content, type);
    }

    public static <T> Generator<T[]> nonEmptyArrays(Generator<? extends T> content, Class<T> type) {
        return Generators.arrays(content, Generators.positiveIntegers(10), type);
    }

    public static <T> Generator<T[]> arrays(Generator<? extends T> content, Generator<Integer> size, Class<T> type) {
        return new ArrayGenerator<T>(content, size, type);
    }

    public static Generator<byte[]> byteArrays() {
        return new ByteArrayGenerator();
    }

    public static Generator<byte[]> byteArrays(Generator<Integer> size) {
        return new ByteArrayGenerator(size);
    }

    public static Generator<byte[]> byteArrays(Generator<Byte> content, Generator<Integer> size) {
        return new ByteArrayGenerator(content, size);
    }

    public static Generator<int[]> intArrays() {
        return new IntegerArrayGenerator();
    }

    public static Generator<int[]> intArrays(Generator<Integer> size) {
        return new IntegerArrayGenerator(size);
    }

    public static Generator<int[]> intArrays(Generator<Integer> content, Generator<Integer> size) {
        return new IntegerArrayGenerator(content, size);
    }

    public static <K, V> Generator<Map<K, V>> maps(Generator<K> keys, Generator<V> values) {
        return new MapGenerator<K, V>(keys, values);
    }

    public static <K, V> Generator<Map<K, V>> maps(Generator<K> keys, Generator<V> values, Generator<Integer> size) {
        return new MapGenerator<K, V>(keys, values, size);
    }

    public static <K, V> Generator<Map<K, V>> maps(Map<K, V> supermap) {
        return new SubmapGenerator<K, V>(supermap);
    }

    public static <K, V> Generator<Map<K, V>> maps(Map<K, V> supermap, Generator<Integer> sizes) {
        return new SubmapGenerator<K, V>(supermap, sizes);
    }

    public static <T> StatefulGenerator<T> ensureValues(Iterable<T> ensuredValues) {
        return new EnsuredValuesGenerator<T>(ensuredValues);
    }

    @SafeVarargs
    public static <T> StatefulGenerator<T> ensureValues(T ... content) {
        return Generators.ensureValues(Arrays.asList(content));
    }

    public static <T> StatefulGenerator<T> ensureValues(Iterable<T> ensuredValues, Generator<T> otherValues) {
        return new EnsuredValuesGenerator<T>(ensuredValues, otherValues);
    }

    public static <T> StatefulGenerator<T> ensureValues(Iterable<T> ensuredValues, int window, Generator<T> otherValues) {
        return new EnsuredValuesGenerator<T>(ensuredValues, window, otherValues);
    }

    public static <T> StatefulGenerator<T> uniqueValues(Generator<T> generator, int tries) {
        return new UniqueValuesGenerator<T>(generator, tries);
    }

    public static <T> StatefulGenerator<T> uniqueValues(Generator<T> generator, Comparator<? super T> comparator, int tries) {
        return new UniqueComparableValuesGenerator<T>(generator, comparator, tries);
    }

    public static <T> StatefulGenerator<T> uniqueValues(Generator<T> generator, Comparator<? super T> comparator) {
        return Generators.uniqueValues(generator, comparator, 100);
    }

    public static <T> StatefulGenerator<T> uniqueValues(Generator<T> generator) {
        return new UniqueValuesGenerator<T>(generator, 100);
    }

    public static <T> Generator<T> excludeValues(Generator<T> generator, T excluded) {
        return Generators.excludeValues(generator, List.of(excluded));
    }

    @SafeVarargs
    public static <T> Generator<T> excludeValues(Generator<T> generator, T ... excluded) {
        return Generators.excludeValues(generator, Arrays.asList(excluded));
    }

    @SafeVarargs
    public static <T> Generator<T> excludeValues(Iterable<T> values, T ... excluded) {
        return Generators.excludeValues(values, Arrays.asList(excluded));
    }

    public static <T> Generator<T> excludeValues(Iterable<T> values, Iterable<T> excluded) {
        return Generators.excludeValues(Generators.fixedValues(values), excluded);
    }

    public static <T> Generator<T> excludeValues(Generator<T> generator, Iterable<T> excluded) {
        return new ExcludingGenerator<T>(generator, excluded, 100);
    }

    public static <T extends Comparable<T>> Generator<List<T>> strictlyOrdered(Generator<T> input) {
        return Generators.strictlyOrdered(input, 0, 10);
    }

    public static <T extends Comparable<T>> Generator<List<T>> strictlyOrdered(Generator<T> input, int low, int high) {
        Comparator natural = Comparable::compareTo;
        return Generators.strictlyOrdered(input, natural, new IntegerGenerator(low, high));
    }

    public static <T> Generator<List<T>> strictlyOrdered(Generator<T> input, Comparator<T> comparator) {
        return Generators.strictlyOrdered(input, comparator, new IntegerGenerator(0, 10));
    }

    public static <T> Generator<List<T>> strictlyOrdered(Generator<T> input, Comparator<T> comparator, Generator<Integer> size) {
        return new StrictlyOrderedGenerator<T>(input, comparator, size);
    }
}

