/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck;

import de.cuioss.test.generator.internal.net.java.quickcheck.Characteristic;
import de.cuioss.test.generator.internal.net.java.quickcheck.CharacteristicException;
import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.GeneratorException;
import de.cuioss.test.generator.internal.net.java.quickcheck.GuardException;
import de.cuioss.test.generator.internal.net.java.quickcheck.NullWriter;
import de.cuioss.test.generator.internal.net.java.quickcheck.Runner;
import de.cuioss.test.generator.internal.net.java.quickcheck.RunnerImpl;
import java.io.PrintWriter;
import lombok.Generated;

public final class QuickCheck {
    public static final int MAX_NUMBER_OF_RUNS = 200;
    public static final int MIN_NUMBER_OF_RUNS = 1;
    public static final String SYSTEM_PROPERTY_RUNS = QuickCheck.propertyName("RUNS");

    public static <T> void forAll(Generator<T> generator, Characteristic<T> characteristic) throws GeneratorException, CharacteristicException {
        QuickCheck.runner(characteristic, 200, generator, new PrintWriter(new NullWriter())).forAll();
    }

    public static int getDefaultNumberOfRuns() {
        Integer runs = Integer.getInteger(SYSTEM_PROPERTY_RUNS, 200);
        return Math.max(1, runs);
    }

    private static String propertyName(String name) {
        return QuickCheck.class.getSimpleName() + "." + name;
    }

    public static <T> void forAll(int runs, Generator<T> generator, Characteristic<T> characteristic) throws GeneratorException, CharacteristicException {
        QuickCheck.runner(characteristic, runs, generator, new PrintWriter(new NullWriter())).forAll();
    }

    public static <T> void forAllVerbose(Generator<T> generator, Characteristic<T> characteristic) throws GeneratorException, CharacteristicException {
        QuickCheck.runner(characteristic, 200, generator, new PrintWriter(new PrintWriter(System.out))).forAll();
    }

    public static <T> void forAllVerbose(int runs, Generator<T> generator, Characteristic<T> characteristic) throws GeneratorException, CharacteristicException {
        QuickCheck.runner(characteristic, runs, generator, new PrintWriter(new PrintWriter(System.out))).forAll();
    }

    public static void guard(boolean predicate) {
        if (!predicate) {
            throw new GuardException();
        }
    }

    private static <T> Runner<T> runner(Characteristic<T> characteristic, int runs, Generator<T> generator, PrintWriter writer) {
        return new RunnerImpl<T>(characteristic, runs, generator, writer);
    }

    @Generated
    private QuickCheck() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

