/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.support;

import de.cuioss.test.generator.internal.net.java.quickcheck.ExtendibleGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.FrequencyGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.CharacterGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.DefaultFrequencyGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.IntegerGenerator;
import java.util.Objects;

public class StringGenerator
implements ExtendibleGenerator<Character, String> {
    public static final int MIN_LENGTH = 0;
    public static final int MAX_LENGTH = 30;
    private final FrequencyGenerator<Character> characters;
    private final Generator<Integer> length;

    public StringGenerator() {
        this(new CharacterGenerator());
    }

    public StringGenerator(char first, char last) {
        this(new CharacterGenerator(first, last));
    }

    public StringGenerator(Generator<Character> characters) {
        this(new IntegerGenerator(0, 30), characters);
    }

    public StringGenerator(Generator<Integer> length, Generator<Character> characters) {
        Objects.requireNonNull(length, "length");
        this.length = length;
        this.characters = new DefaultFrequencyGenerator<Character>(characters);
    }

    @Override
    public String next() {
        int size = this.length.next();
        StringBuilder builder = new StringBuilder();
        for (int count = 0; count < size; ++count) {
            builder.append(this.characters.next());
        }
        return builder.toString();
    }

    @Override
    public ExtendibleGenerator<Character, String> add(Generator<Character> characterGenerator) {
        this.characters.add(characterGenerator);
        return this;
    }
}

