/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.impl;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;
import java.time.ZonedDateTime;

public class ZonedDateTimeGenerator
implements TypedGenerator<ZonedDateTime> {
    private static final TypedGenerator<Integer> SOME_INT = Generators.integers(0, 10);

    @Override
    public ZonedDateTime next() {
        return ZonedDateTime.ofInstant(Generators.dates().next().toInstant(), Generators.zoneIds().next());
    }

    @Override
    public Class<ZonedDateTime> getType() {
        return ZonedDateTime.class;
    }

    public static ZonedDateTime any() {
        return new ZonedDateTimeGenerator().next();
    }

    public static ZonedDateTime now() {
        return ZonedDateTime.now();
    }

    public static ZonedDateTime someMinutesAgo() {
        return ZonedDateTimeGenerator.now().minusMinutes(SOME_INT.next().intValue());
    }

    public static ZonedDateTime someHoursAgo() {
        return ZonedDateTimeGenerator.now().minusHours(SOME_INT.next().intValue());
    }

    public static ZonedDateTime someDaysAgo() {
        return ZonedDateTimeGenerator.now().minusDays(SOME_INT.next().intValue());
    }

    public static ZonedDateTime someWeeksAgo() {
        return ZonedDateTimeGenerator.now().minusWeeks(SOME_INT.next().intValue());
    }

    public static ZonedDateTime someMonthsAgo() {
        return ZonedDateTimeGenerator.now().minusMonths(SOME_INT.next().intValue());
    }

    public static ZonedDateTime someYearsAgo() {
        return ZonedDateTimeGenerator.now().minusYears(SOME_INT.next().intValue());
    }

    public static ZonedDateTime lastTenYearsAgo() {
        return ZonedDateTimeGenerator.now().minusYears(SOME_INT.next().intValue()).minusMonths(SOME_INT.next().intValue()).minusDays(SOME_INT.next().intValue());
    }

    public static ZonedDateTime lastMonthAgo() {
        return ZonedDateTimeGenerator.now().minusMinutes(SOME_INT.next().intValue()).minusHours(SOME_INT.next().intValue()).minusDays(SOME_INT.next().intValue());
    }
}

