/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.impl;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.generator.impl.FloatObjectGenerator;
import de.cuioss.test.generator.impl.ShortObjectGenerator;
import de.cuioss.tools.base.Preconditions;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PrimitiveArrayGenerators {
    BOOLEAN{

        @Override
        public Object next() {
            int size = sizeGenerator.next();
            TypedGenerator<Boolean> generator = Generators.booleans();
            boolean[] array = new boolean[size];
            for (int index = 0; index < size; ++index) {
                array[index] = generator.next();
            }
            return array;
        }

        @Override
        public Class<?> getType() {
            return Boolean.TYPE;
        }
    }
    ,
    BYTE{

        @Override
        public Object next() {
            int size = sizeGenerator.next();
            TypedGenerator<Byte> generator = Generators.bytes();
            byte[] array = new byte[size];
            for (int index = 0; index < size; ++index) {
                array[index] = generator.next();
            }
            return array;
        }

        @Override
        public Class<?> getType() {
            return Byte.TYPE;
        }
    }
    ,
    CHAR{

        @Override
        public Object next() {
            int size = sizeGenerator.next();
            TypedGenerator<Character> generator = Generators.characters();
            char[] array = new char[size];
            for (int index = 0; index < size; ++index) {
                array[index] = generator.next().charValue();
            }
            return array;
        }

        @Override
        public Class<?> getType() {
            return Character.TYPE;
        }
    }
    ,
    SHORT{

        @Override
        public Object next() {
            int size = sizeGenerator.next();
            ShortObjectGenerator generator = new ShortObjectGenerator();
            short[] array = new short[size];
            for (int index = 0; index < size; ++index) {
                array[index] = (Short)generator.next();
            }
            return array;
        }

        @Override
        public Class<?> getType() {
            return Short.TYPE;
        }
    }
    ,
    INTEGER{

        @Override
        public Object next() {
            int size = sizeGenerator.next();
            TypedGenerator<Integer> generator = Generators.integers();
            int[] array = new int[size];
            for (int index = 0; index < size; ++index) {
                array[index] = generator.next();
            }
            return array;
        }

        @Override
        public Class<?> getType() {
            return Integer.TYPE;
        }
    }
    ,
    LONG{

        @Override
        public Object next() {
            int size = sizeGenerator.next();
            TypedGenerator<Long> generator = Generators.longs();
            long[] array = new long[size];
            for (int index = 0; index < size; ++index) {
                array[index] = generator.next();
            }
            return array;
        }

        @Override
        public Class<?> getType() {
            return Long.TYPE;
        }
    }
    ,
    FLOAT{

        @Override
        public Object next() {
            int size = sizeGenerator.next();
            FloatObjectGenerator generator = new FloatObjectGenerator();
            float[] array = new float[size];
            for (int index = 0; index < size; ++index) {
                array[index] = ((Float)generator.next()).floatValue();
            }
            return array;
        }

        @Override
        public Class<?> getType() {
            return Float.TYPE;
        }
    }
    ,
    DOUBLE{

        @Override
        public Object next() {
            int size = sizeGenerator.next();
            TypedGenerator<Double> generator = Generators.doubles();
            double[] array = new double[size];
            for (int index = 0; index < size; ++index) {
                array[index] = generator.next();
            }
            return array;
        }

        @Override
        public Class<?> getType() {
            return Double.TYPE;
        }
    };

    private static final TypedGenerator<Integer> sizeGenerator;

    public abstract Object next();

    public abstract Class<?> getType();

    public static PrimitiveArrayGenerators resolveForType(Class<?> primitiveType) {
        Objects.requireNonNull(primitiveType);
        Preconditions.checkArgument((boolean)primitiveType.isPrimitive(), (String)("You must provide a primitive type, given: " + primitiveType));
        for (PrimitiveArrayGenerators generator : PrimitiveArrayGenerators.values()) {
            if (!primitiveType.equals(generator.getType())) continue;
            return generator;
        }
        throw new IllegalStateException("No generator registered for type " + primitiveType);
    }

    static {
        sizeGenerator = Generators.integers(0, 128);
    }
}

