/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.impl;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.logging.CuiLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CollectionGenerator<T>
implements TypedGenerator<T> {
    private static final CuiLogger log = new CuiLogger(CollectionGenerator.class);
    private static final String JAVA_UTIL_SORTED_SET = "java.util.SortedSet";
    private static final String JAVA_UTIL_COLLECTION = "java.util.Collection";
    private static final String JAVA_UTIL_SET = "java.util.Set";
    private static final String JAVA_UTIL_LIST = "java.util.List";
    private final TypedGenerator<T> wrapped;
    private final TypedGenerator<Integer> sizeGenerator;

    public CollectionGenerator(TypedGenerator<T> wrapped, TypedGenerator<Integer> sizeGenerator) {
        this.wrapped = Objects.requireNonNull(wrapped, "wrapped must not be null");
        this.sizeGenerator = Objects.requireNonNull(sizeGenerator, "sizeGenerator must not be null");
    }

    public CollectionGenerator(TypedGenerator<T> wrapped, int lowerBound, int upperBound) {
        this(wrapped, Generators.integers(lowerBound, upperBound));
    }

    public CollectionGenerator(TypedGenerator<T> wrapped) {
        this(wrapped, 2, 12);
    }

    @Override
    public T next() {
        return this.wrapped.next();
    }

    public List<T> list(int count) {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < count; ++i) {
            result.add(this.next());
        }
        return result;
    }

    public Set<T> set(int count) {
        Set result = CollectionLiterals.mutableSet();
        for (int i = 0; i < count; ++i) {
            result.add(this.next());
        }
        return result;
    }

    public SortedSet<T> sortedSet(int count) {
        return new TreeSet<T>(this.set(count));
    }

    public Set<T> set() {
        return this.set(this.sizeGenerator.next());
    }

    public List<T> list() {
        return this.list(this.sizeGenerator.next());
    }

    public SortedSet<T> sortedSet() {
        return this.sortedSet(this.sizeGenerator.next());
    }

    public Iterable<T> nextCollection(Class<? extends Iterable<?>> expectedType) {
        Objects.requireNonNull(expectedType, "expectedType must not be null");
        return switch (expectedType.getName()) {
            case JAVA_UTIL_LIST -> this.list();
            case JAVA_UTIL_SET -> this.set();
            case JAVA_UTIL_COLLECTION -> this.list();
            case JAVA_UTIL_SORTED_SET -> this.sortedSet();
            default -> {
                log.info("No specific case defined for {}. Returning list-implementation.", new Object[]{expectedType.getName()});
                yield this.list();
            }
        };
    }
}

