/*
 * Copyright 2023 the original author or authors.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * https://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.cuioss.test.jsf.component;

import de.cuioss.test.jsf.config.component.VerifyComponentProperties;
import jakarta.faces.component.UIComponent;

/**
 * Extension to {@link AbstractComponentTest} that implicitly tests a number of
 * standard attributes like 'style', 'styleClass', 'rendered'
 *
 * @param <T> identifying the type to be tested, at least an {@link UIComponent}
 * @author Oliver Wolff
 */
@VerifyComponentProperties(of = {"style", "styleClass", "rendered"})
public abstract class AbstractUiComponentTest<T extends UIComponent> extends AbstractComponentTest<T> {

}
