/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.portal.restclient;

import de.cuioss.tools.logging.CuiLogger;
import jakarta.annotation.Priority;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import java.io.IOException;

@Priority(value=-2147483648)
abstract class LogClientResponseFilter
implements ClientResponseFilter {
    private static final String PATTERN = "-- Client response filter {}--\nStatus: {}\nStatusInfo: {}\nAllowed Methods: {}\nEntityTag: {}\nCookies: {}\nDate: {}\nHeaders: {}\nLanguage: {}\nLastModified: {}\nLinks: {}\nLocation: {}\nMediaType: {}\n";
    private final CuiLogger log;
    private final String name;

    protected LogClientResponseFilter(CuiLogger logger) {
        this(logger, "");
    }

    protected LogClientResponseFilter(CuiLogger logger, String name) {
        this.log = logger;
        this.name = "[" + name + "] ";
    }

    public void filter(ClientRequestContext clientRequestContext, ClientResponseContext clientResponseContext) throws IOException {
        try {
            this.log.info(PATTERN, new Object[]{this.name, clientResponseContext.getStatus(), clientResponseContext.getStatusInfo(), clientResponseContext.getAllowedMethods(), clientResponseContext.getEntityTag(), clientResponseContext.getCookies(), clientResponseContext.getDate(), clientResponseContext.getHeaders(), clientResponseContext.getLanguage(), clientResponseContext.getLastModified(), clientResponseContext.getLinks(), clientResponseContext.getLocation(), clientResponseContext.getMediaType()});
        }
        catch (Exception e) {
            this.log.error("Portal-529: Could not trace-log response data", (Throwable)e);
        }
    }
}

